/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.video.tools.service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolder;
import org.nuxeo.ecm.platform.commandline.executor.api.CmdParameters;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandAvailability;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandLineExecutorService;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandNotAvailable;
import org.nuxeo.ecm.platform.commandline.executor.api.ExecResult;
import org.nuxeo.ecm.platform.video.tools.VideoClosedCaptionsExtractor;
import org.nuxeo.ecm.platform.video.tools.VideoConcat;
import org.nuxeo.ecm.platform.video.tools.VideoSlicer;
import org.nuxeo.ecm.platform.video.tools.VideoTool;
import org.nuxeo.ecm.platform.video.tools.VideoToolsService;
import org.nuxeo.ecm.platform.video.tools.VideoWatermarker;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;

public class VideoToolsServiceImpl
extends DefaultComponent
implements VideoToolsService {
    protected static final Log log = LogFactory.getLog(VideoToolsServiceImpl.class);
    protected Map<String, Class<?>> videoTools;

    public void activate(ComponentContext context) {
        super.activate(context);
        this.videoTools = new HashMap();
        this.videoTools.put("watermarkerTool", VideoWatermarker.class);
        this.videoTools.put("slicerTool", VideoSlicer.class);
        this.videoTools.put("concatTool", VideoConcat.class);
        this.videoTools.put("ccExtractorTool", VideoClosedCaptionsExtractor.class);
    }

    public Blob extractClosedCaptions(Blob video, String outputFormat, String startAt, String endAt) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("outFormat", outputFormat);
        parameters.put("startAt", startAt);
        parameters.put("endAt", endAt);
        BlobHolder result = this.execute("ccExtractorTool", (BlobHolder)new SimpleBlobHolder(video), parameters);
        return result.getBlob();
    }

    public Blob concat(List<Blob> videos) {
        BlobHolder blobHolder = this.execute("concatTool", (BlobHolder)new SimpleBlobHolder(videos), null);
        return blobHolder.getBlob();
    }

    public List<Blob> slice(Blob video, String startAt, String duration, boolean encode) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("duration", duration);
        parameters.put("startAt", startAt);
        parameters.put("encode", encode);
        BlobHolder result = this.execute("slicerTool", (BlobHolder)new SimpleBlobHolder(video), parameters);
        return result.getBlobs();
    }

    public Blob watermark(Blob video, Blob picture, String x, String y) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("pictureFilePath", picture);
        parameters.put("x", x);
        parameters.put("y", y);
        BlobHolder result = this.execute("watermarkerTool", (BlobHolder)new SimpleBlobHolder(video), parameters);
        return result.getBlob();
    }

    private BlobHolder execute(String toolName, BlobHolder blobHolder, Map<String, Object> parameters) {
        BlobHolder result = null;
        if (!this.isToolAvailable(toolName)) {
            return result;
        }
        try {
            VideoTool tool = (VideoTool)this.videoTools.get(toolName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Map params = tool.setupParameters(blobHolder, parameters);
            CmdParameters cmdParams = this.setupCmdParameters(params);
            String commandLineName = tool.getCommandLineName();
            CommandLineExecutorService cles = (CommandLineExecutorService)Framework.getService(CommandLineExecutorService.class);
            ExecResult clResult = cles.execCommand(commandLineName, cmdParams);
            tool.cleanupInputs(params);
            if (clResult.getError() != null) {
                throw new NuxeoException("Failed to execute the command <" + commandLineName + ">", (Throwable)clResult.getError());
            }
            if (!clResult.isSuccessful()) {
                throw new NuxeoException("Failed to execute the command <" + commandLineName + ">. Final command [ " + clResult.getCommandLine() + " ] returned with error " + clResult.getReturnCode());
            }
            result = tool.buildResult(blobHolder.getBlob().getMimeType(), params);
        }
        catch (CommandNotAvailable e) {
            throw new NuxeoException("The video tool command is not available.", (Throwable)e);
        }
        catch (ReflectiveOperationException e) {
            throw new NuxeoException("The video tool is not available.", (Throwable)e);
        }
        return result;
    }

    public boolean isToolAvailable(String toolName) {
        String commandLine;
        try {
            VideoTool tool = (VideoTool)this.videoTools.get(toolName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            commandLine = tool.getCommandLineName();
        }
        catch (ReflectiveOperationException e) {
            throw new NuxeoException("The video tool is not available.", (Throwable)e);
        }
        CommandAvailability ca = ((CommandLineExecutorService)Framework.getService(CommandLineExecutorService.class)).getCommandAvailability(commandLine);
        return ca.isAvailable();
    }

    protected CmdParameters setupCmdParameters(Map<String, String> parameters) {
        CmdParameters cmdParameters = new CmdParameters();
        for (String param : parameters.keySet()) {
            cmdParameters.addNamedParameter(param, parameters.get(param));
        }
        return cmdParameters;
    }
}

