/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.onedrive.client;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.nuxeo.onedrive.client.AbstractResponse;
import org.nuxeo.onedrive.client.OneDriveAPI;
import org.nuxeo.onedrive.client.OneDriveAPIException;

public abstract class AbstractRequest<R extends AbstractResponse> {
    private static final int MAX_REDIRECTS = 3;
    private static final String USER_AGENT = "Nuxeo OneDrive Java SDK v1.0";
    private final OneDriveAPI api;
    private final List<RequestHeader> headers;
    private final String method;
    private URL url;
    private int timeout;
    private InputStream body;
    private long bodyLength;
    private int numRedirects;

    public AbstractRequest(URL url, String method) {
        this(null, url, method);
    }

    public AbstractRequest(OneDriveAPI api, URL url, String method) {
        this.api = api;
        this.url = Objects.requireNonNull(url);
        this.method = Objects.requireNonNull(method);
        this.headers = new ArrayList<RequestHeader>();
        this.addHeader("Accept-Encoding", "gzip");
        this.addHeader("Accept-Charset", "utf-8");
    }

    public void addHeader(String key, String value) {
        this.headers.add(new RequestHeader(key, value));
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    protected InputStream getBody() {
        return this.body;
    }

    protected void setBody(InputStream stream) {
        this.body = stream;
    }

    protected void setBody(InputStream stream, long length) {
        this.bodyLength = length;
        this.body = stream;
    }

    protected void setBody(String body) {
        byte[] bytes = body.getBytes(StandardCharsets.UTF_8);
        this.bodyLength = bytes.length;
        this.body = new ByteArrayInputStream(bytes);
    }

    protected void writeBody(HttpURLConnection connection) throws OneDriveAPIException {
        if (this.body == null) {
            return;
        }
        connection.setDoOutput(true);
        try (OutputStream output = connection.getOutputStream();){
            int b = this.body.read();
            while (b != -1) {
                output.write(b);
                b = this.body.read();
            }
        }
        catch (IOException e) {
            throw new OneDriveAPIException("Couldn't connect to the OneDrive API due to a network error.", e);
        }
    }

    public R send() throws OneDriveAPIException {
        int responseCode;
        HttpURLConnection connection = this.createConnection();
        connection.setRequestProperty("User-Agent", USER_AGENT);
        if (this.api != null) {
            connection.addRequestProperty("Authorization", "Bearer " + this.api.getAccessToken());
        }
        this.writeBody(connection);
        try {
            connection.connect();
        }
        catch (IOException e) {
            throw new OneDriveAPIException("Couldn't connect to the OneDrive API due to a network error.", e);
        }
        try {
            responseCode = connection.getResponseCode();
        }
        catch (IOException e) {
            throw new OneDriveAPIException("Couldn't connect to the OneDrive API due to a network error.", e);
        }
        if (AbstractRequest.isResponseRedirect(responseCode)) {
            return this.handleRedirect(connection);
        }
        return this.createResponse(connection);
    }

    private R handleRedirect(HttpURLConnection connection) throws OneDriveAPIException {
        if (this.numRedirects >= 3) {
            throw new OneDriveAPIException("The OneDrive API responded with too many redirects.");
        }
        ++this.numRedirects;
        try {
            AbstractResponse.readStream(connection.getInputStream());
        }
        catch (IOException e) {
            throw new OneDriveAPIException("Couldn't connect to the OneDrive API due to a network error.", e);
        }
        try {
            String redirect = connection.getHeaderField("Location");
            this.url = new URL(redirect);
        }
        catch (MalformedURLException e) {
            throw new OneDriveAPIException("The OneDrive API responded with an invalid redirect url.", e);
        }
        return this.send();
    }

    private HttpURLConnection createConnection() throws OneDriveAPIException {
        HttpURLConnection connection;
        try {
            connection = (HttpURLConnection)this.url.openConnection();
        }
        catch (IOException e) {
            throw new OneDriveAPIException("Couldn't connect to OneDrive API due to a network error.", e);
        }
        try {
            connection.setRequestMethod(this.method);
        }
        catch (ProtocolException e) {
            throw new OneDriveAPIException("Couldn't connect to OneDrive API because method is not correct.", e);
        }
        connection.setConnectTimeout(this.timeout);
        connection.setReadTimeout(this.timeout);
        connection.setInstanceFollowRedirects(false);
        this.headers.forEach(header -> connection.addRequestProperty(header.getKey(), header.getValue()));
        return connection;
    }

    private static boolean isResponseRedirect(int responseCode) {
        return responseCode == 301 || responseCode == 302;
    }

    protected abstract R createResponse(HttpURLConnection var1) throws OneDriveAPIException;

    private final class RequestHeader {
        private final String key;
        private final String value;

        public RequestHeader(String key, String value) {
            this.key = Objects.requireNonNull(key);
            this.value = Objects.requireNonNull(value);
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }
    }
}

