/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.onedrive.client;

import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import com.eclipsesource.json.ParseException;
import java.io.InputStream;
import java.net.URL;
import org.nuxeo.onedrive.client.OneDriveAPI;
import org.nuxeo.onedrive.client.OneDriveAPIException;
import org.nuxeo.onedrive.client.OneDriveExpand;
import org.nuxeo.onedrive.client.OneDriveItem;
import org.nuxeo.onedrive.client.OneDriveJsonRequest;
import org.nuxeo.onedrive.client.OneDriveJsonResponse;
import org.nuxeo.onedrive.client.OneDriveRequest;
import org.nuxeo.onedrive.client.OneDriveResponse;
import org.nuxeo.onedrive.client.OneDriveRuntimeException;
import org.nuxeo.onedrive.client.QueryStringBuilder;
import org.nuxeo.onedrive.client.URLTemplate;

public class OneDriveFile
extends OneDriveItem {
    private static final URLTemplate GET_FILE_URL = new URLTemplate("/drive/items/%s");
    private static final URLTemplate GET_FILE_CONTENT_URL = new URLTemplate("/drive/items/%s/content");

    public OneDriveFile(OneDriveAPI api, String id) {
        super(api, id);
    }

    @Override
    public Metadata getMetadata(OneDriveExpand ... expands) throws OneDriveAPIException {
        QueryStringBuilder query = new QueryStringBuilder().set("expand", expands);
        URL url = GET_FILE_URL.build(this.getApi().getBaseURL(), query, this.getId());
        OneDriveJsonRequest request = new OneDriveJsonRequest(this.getApi(), url, "GET");
        OneDriveJsonResponse response = (OneDriveJsonResponse)request.send();
        return new Metadata(response.getContent());
    }

    public InputStream download() throws OneDriveAPIException {
        URL url = GET_FILE_CONTENT_URL.build(this.getApi().getBaseURL(), this.getId());
        OneDriveRequest request = new OneDriveRequest(this.getApi(), url, "GET");
        OneDriveResponse response = (OneDriveResponse)request.send();
        return response.getContent();
    }

    public class Metadata
    extends OneDriveItem.Metadata {
        private String cTag;
        private String mimeType;
        private String downloadUrl;
        private String crc32Hash;
        private String sha1Hash;

        public Metadata(JsonObject json) {
            super(json);
        }

        public String getCTag() {
            return this.cTag;
        }

        public String getVersion() {
            return this.cTag == null ? null : this.cTag.substring(this.cTag.lastIndexOf(44) + 1);
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public String getDownloadUrl() {
            return this.downloadUrl;
        }

        public String getCrc32Hash() {
            return this.crc32Hash;
        }

        public String getSha1Hash() {
            return this.sha1Hash;
        }

        @Override
        protected void parseMember(JsonObject.Member member) {
            super.parseMember(member);
            try {
                JsonValue value = member.getValue();
                String memberName = member.getName();
                if ("cTag".equals(memberName)) {
                    this.cTag = value.asString();
                } else if ("@content.downloadUrl".equals(memberName)) {
                    this.downloadUrl = value.asString();
                } else if ("file".equals(memberName)) {
                    Metadata.parseMember(value.asObject(), this::parseFileMember);
                }
            }
            catch (ParseException e) {
                throw new OneDriveRuntimeException("Parse failed, maybe a bug in client.", e);
            }
        }

        private void parseFileMember(JsonObject.Member member) {
            JsonValue value = member.getValue();
            String memberName = member.getName();
            if ("mimeType".equals(memberName)) {
                this.mimeType = value.asString();
            } else if ("hashes".equals(memberName)) {
                Metadata.parseMember(value.asObject(), this::parseHashesMember);
            }
        }

        private void parseHashesMember(JsonObject.Member member) {
            JsonValue value = member.getValue();
            String memberName = member.getName();
            if ("crc32Hash".equals(memberName)) {
                this.crc32Hash = value.asString();
            } else if ("sha1Hash".equals(memberName)) {
                this.sha1Hash = value.asString();
            }
        }

        @Override
        public OneDriveFile getResource() {
            return OneDriveFile.this;
        }

        @Override
        public boolean isFile() {
            return true;
        }

        @Override
        public Metadata asFile() {
            return this;
        }
    }
}

