/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.onedrive.client;

import com.eclipsesource.json.JsonObject;
import java.net.HttpURLConnection;
import java.net.URL;
import org.nuxeo.onedrive.client.AbstractRequest;
import org.nuxeo.onedrive.client.OneDriveAPI;
import org.nuxeo.onedrive.client.OneDriveAPIException;
import org.nuxeo.onedrive.client.OneDriveJsonResponse;

public class OneDriveJsonRequest
extends AbstractRequest<OneDriveJsonResponse> {
    public OneDriveJsonRequest(URL url, String method) {
        super(url, method);
    }

    public OneDriveJsonRequest(OneDriveAPI api, URL url, String method) {
        super(api, url, method);
        if (!"GET".equals(method)) {
            this.addHeader("Content-Type", "application/json");
        }
        this.addHeader("accept", "application/json");
    }

    @Override
    protected OneDriveJsonResponse createResponse(HttpURLConnection connection) throws OneDriveAPIException {
        return new OneDriveJsonResponse(connection);
    }

    public void setBody(JsonObject body) {
        this.setBody(body.toString());
    }
}

