/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.teamcommon.GroupManagementType;
import com.dropbox.core.v2.teamcommon.GroupSummary;
import com.dropbox.core.v2.teamcommon.GroupType;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public class GroupInfo
extends GroupSummary {
    protected final GroupType groupType;
    protected final boolean isOwner;
    protected final boolean sameTeam;

    public GroupInfo(String groupName, String groupId, GroupManagementType groupManagementType, GroupType groupType, boolean isOwner, boolean sameTeam, String groupExternalId, Long memberCount) {
        super(groupName, groupId, groupManagementType, groupExternalId, memberCount);
        if (groupType == null) {
            throw new IllegalArgumentException("Required value for 'groupType' is null");
        }
        this.groupType = groupType;
        this.isOwner = isOwner;
        this.sameTeam = sameTeam;
    }

    public GroupInfo(String groupName, String groupId, GroupManagementType groupManagementType, GroupType groupType, boolean isOwner, boolean sameTeam) {
        this(groupName, groupId, groupManagementType, groupType, isOwner, sameTeam, null, null);
    }

    @Override
    public String getGroupName() {
        return this.groupName;
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public GroupManagementType getGroupManagementType() {
        return this.groupManagementType;
    }

    public GroupType getGroupType() {
        return this.groupType;
    }

    public boolean getIsOwner() {
        return this.isOwner;
    }

    public boolean getSameTeam() {
        return this.sameTeam;
    }

    @Override
    public String getGroupExternalId() {
        return this.groupExternalId;
    }

    @Override
    public Long getMemberCount() {
        return this.memberCount;
    }

    public static Builder newBuilder(String groupName, String groupId, GroupManagementType groupManagementType, GroupType groupType, boolean isOwner, boolean sameTeam) {
        return new Builder(groupName, groupId, groupManagementType, groupType, isOwner, sameTeam);
    }

    @Override
    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.groupType, this.isOwner, this.sameTeam});
        hash = 31 * super.hashCode() + hash;
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            GroupInfo other = (GroupInfo)obj;
            return !(this.groupName != other.groupName && !this.groupName.equals(other.groupName) || this.groupId != other.groupId && !this.groupId.equals(other.groupId) || this.groupManagementType != other.groupManagementType && !this.groupManagementType.equals((Object)other.groupManagementType) || this.groupType != other.groupType && !this.groupType.equals((Object)other.groupType) || this.isOwner != other.isOwner || this.sameTeam != other.sameTeam || this.groupExternalId != other.groupExternalId && (this.groupExternalId == null || !this.groupExternalId.equals(other.groupExternalId)) || this.memberCount != other.memberCount && (this.memberCount == null || !this.memberCount.equals(other.memberCount)));
        }
        return false;
    }

    @Override
    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    @Override
    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<GroupInfo> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(GroupInfo value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("group_name");
            StoneSerializers.string().serialize(value.groupName, g);
            g.writeFieldName("group_id");
            StoneSerializers.string().serialize(value.groupId, g);
            g.writeFieldName("group_management_type");
            GroupManagementType.Serializer.INSTANCE.serialize(value.groupManagementType, g);
            g.writeFieldName("group_type");
            GroupType.Serializer.INSTANCE.serialize(value.groupType, g);
            g.writeFieldName("is_owner");
            StoneSerializers.boolean_().serialize((Boolean)value.isOwner, g);
            g.writeFieldName("same_team");
            StoneSerializers.boolean_().serialize((Boolean)value.sameTeam, g);
            if (value.groupExternalId != null) {
                g.writeFieldName("group_external_id");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.groupExternalId, g);
            }
            if (value.memberCount != null) {
                g.writeFieldName("member_count");
                StoneSerializers.nullable(StoneSerializers.uInt32()).serialize(value.memberCount, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public GroupInfo deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            Long f_memberCount;
            String f_groupExternalId;
            Boolean f_sameTeam;
            Boolean f_isOwner;
            GroupType f_groupType;
            GroupManagementType f_groupManagementType;
            String f_groupId;
            String f_groupName;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_groupName = null;
                f_groupId = null;
                f_groupManagementType = null;
                f_groupType = null;
                f_isOwner = null;
                f_sameTeam = null;
                f_groupExternalId = null;
                f_memberCount = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("group_name".equals(field)) {
                        f_groupName = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("group_id".equals(field)) {
                        f_groupId = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("group_management_type".equals(field)) {
                        f_groupManagementType = GroupManagementType.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("group_type".equals(field)) {
                        f_groupType = GroupType.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("is_owner".equals(field)) {
                        f_isOwner = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    if ("same_team".equals(field)) {
                        f_sameTeam = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    if ("group_external_id".equals(field)) {
                        f_groupExternalId = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("member_count".equals(field)) {
                        f_memberCount = StoneSerializers.nullable(StoneSerializers.uInt32()).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_groupName == null) {
                    throw new JsonParseException(p, "Required field \"group_name\" missing.");
                }
                if (f_groupId == null) {
                    throw new JsonParseException(p, "Required field \"group_id\" missing.");
                }
                if (f_groupManagementType == null) {
                    throw new JsonParseException(p, "Required field \"group_management_type\" missing.");
                }
                if (f_groupType == null) {
                    throw new JsonParseException(p, "Required field \"group_type\" missing.");
                }
                if (f_isOwner == null) {
                    throw new JsonParseException(p, "Required field \"is_owner\" missing.");
                }
                if (f_sameTeam == null) {
                    throw new JsonParseException(p, "Required field \"same_team\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            GroupInfo value = new GroupInfo(f_groupName, f_groupId, f_groupManagementType, f_groupType, f_isOwner, f_sameTeam, f_groupExternalId, f_memberCount);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static class Builder
    extends GroupSummary.Builder {
        protected final GroupType groupType;
        protected final boolean isOwner;
        protected final boolean sameTeam;

        protected Builder(String groupName, String groupId, GroupManagementType groupManagementType, GroupType groupType, boolean isOwner, boolean sameTeam) {
            super(groupName, groupId, groupManagementType);
            if (groupType == null) {
                throw new IllegalArgumentException("Required value for 'groupType' is null");
            }
            this.groupType = groupType;
            this.isOwner = isOwner;
            this.sameTeam = sameTeam;
        }

        @Override
        public Builder withGroupExternalId(String groupExternalId) {
            super.withGroupExternalId(groupExternalId);
            return this;
        }

        @Override
        public Builder withMemberCount(Long memberCount) {
            super.withMemberCount(memberCount);
            return this;
        }

        @Override
        public GroupInfo build() {
            return new GroupInfo(this.groupName, this.groupId, this.groupManagementType, this.groupType, this.isOwner, this.sameTeam, this.groupExternalId, this.memberCount);
        }
    }
}

