/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.sharing.MemberAction;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;

class ListFileMembersArg {
    protected final String file;
    protected final List<MemberAction> actions;
    protected final boolean includeInherited;
    protected final long limit;

    public ListFileMembersArg(String file, List<MemberAction> actions, boolean includeInherited, long limit) {
        if (file == null) {
            throw new IllegalArgumentException("Required value for 'file' is null");
        }
        if (file.length() < 1) {
            throw new IllegalArgumentException("String 'file' is shorter than 1");
        }
        if (!Pattern.matches("((/|id:).*|nspath:[0-9]+:.*)|ns:[0-9]+(/.*)?", file)) {
            throw new IllegalArgumentException("String 'file' does not match pattern");
        }
        this.file = file;
        if (actions != null) {
            for (MemberAction x : actions) {
                if (x != null) continue;
                throw new IllegalArgumentException("An item in list 'actions' is null");
            }
        }
        this.actions = actions;
        this.includeInherited = includeInherited;
        if (limit < 1L) {
            throw new IllegalArgumentException("Number 'limit' is smaller than 1L");
        }
        if (limit > 300L) {
            throw new IllegalArgumentException("Number 'limit' is larger than 300L");
        }
        this.limit = limit;
    }

    public ListFileMembersArg(String file) {
        this(file, null, true, 100L);
    }

    public String getFile() {
        return this.file;
    }

    public List<MemberAction> getActions() {
        return this.actions;
    }

    public boolean getIncludeInherited() {
        return this.includeInherited;
    }

    public long getLimit() {
        return this.limit;
    }

    public static Builder newBuilder(String file) {
        return new Builder(file);
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.file, this.actions, this.includeInherited, this.limit});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            ListFileMembersArg other = (ListFileMembersArg)obj;
            return (this.file == other.file || this.file.equals(other.file)) && (this.actions == other.actions || this.actions != null && this.actions.equals(other.actions)) && this.includeInherited == other.includeInherited && this.limit == other.limit;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<ListFileMembersArg> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(ListFileMembersArg value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("file");
            StoneSerializers.string().serialize(value.file, g);
            if (value.actions != null) {
                g.writeFieldName("actions");
                StoneSerializers.nullable(StoneSerializers.list(MemberAction.Serializer.INSTANCE)).serialize(value.actions, g);
            }
            g.writeFieldName("include_inherited");
            StoneSerializers.boolean_().serialize((Boolean)value.includeInherited, g);
            g.writeFieldName("limit");
            StoneSerializers.uInt32().serialize((Long)value.limit, g);
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public ListFileMembersArg deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            Long f_limit;
            Boolean f_includeInherited;
            List<MemberAction> f_actions;
            String f_file;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_file = null;
                f_actions = null;
                f_includeInherited = true;
                f_limit = 100L;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("file".equals(field)) {
                        f_file = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("actions".equals(field)) {
                        f_actions = StoneSerializers.nullable(StoneSerializers.list(MemberAction.Serializer.INSTANCE)).deserialize(p);
                        continue;
                    }
                    if ("include_inherited".equals(field)) {
                        f_includeInherited = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    if ("limit".equals(field)) {
                        f_limit = StoneSerializers.uInt32().deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_file == null) {
                    throw new JsonParseException(p, "Required field \"file\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            ListFileMembersArg value = new ListFileMembersArg(f_file, f_actions, f_includeInherited, f_limit);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static class Builder {
        protected final String file;
        protected List<MemberAction> actions;
        protected boolean includeInherited;
        protected long limit;

        protected Builder(String file) {
            if (file == null) {
                throw new IllegalArgumentException("Required value for 'file' is null");
            }
            if (file.length() < 1) {
                throw new IllegalArgumentException("String 'file' is shorter than 1");
            }
            if (!Pattern.matches("((/|id:).*|nspath:[0-9]+:.*)|ns:[0-9]+(/.*)?", file)) {
                throw new IllegalArgumentException("String 'file' does not match pattern");
            }
            this.file = file;
            this.actions = null;
            this.includeInherited = true;
            this.limit = 100L;
        }

        public Builder withActions(List<MemberAction> actions) {
            if (actions != null) {
                for (MemberAction x : actions) {
                    if (x != null) continue;
                    throw new IllegalArgumentException("An item in list 'actions' is null");
                }
            }
            this.actions = actions;
            return this;
        }

        public Builder withIncludeInherited(Boolean includeInherited) {
            this.includeInherited = includeInherited != null ? includeInherited : true;
            return this;
        }

        public Builder withLimit(Long limit) {
            if (limit < 1L) {
                throw new IllegalArgumentException("Number 'limit' is smaller than 1L");
            }
            if (limit > 300L) {
                throw new IllegalArgumentException("Number 'limit' is larger than 300L");
            }
            this.limit = limit != null ? limit : 100L;
            return this;
        }

        public ListFileMembersArg build() {
            return new ListFileMembersArg(this.file, this.actions, this.includeInherited, this.limit);
        }
    }
}

