/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.teamcommon;

import com.dropbox.core.stone.UnionSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;

public enum GroupType {
    TEAM,
    USER_MANAGED,
    OTHER;


    public static class Serializer
    extends UnionSerializer<GroupType> {
        public static final Serializer INSTANCE = new Serializer();

        @Override
        public void serialize(GroupType value, JsonGenerator g) throws IOException, JsonGenerationException {
            switch (value) {
                case TEAM: {
                    g.writeString("team");
                    break;
                }
                case USER_MANAGED: {
                    g.writeString("user_managed");
                    break;
                }
                default: {
                    g.writeString("other");
                }
            }
        }

        @Override
        public GroupType deserialize(JsonParser p) throws IOException, JsonParseException {
            GroupType value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("team".equals(tag)) {
                value = TEAM;
            } else if ("user_managed".equals(tag)) {
                value = USER_MANAGED;
            } else {
                value = OTHER;
                Serializer.skipFields(p);
            }
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }
}

