/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.liveconnect.core;

import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;

public class LiveConnectFileInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String user;
    private final String fileId;
    private final String revisionId;

    public LiveConnectFileInfo(String user, String fileId) {
        this(user, fileId, null);
    }

    public LiveConnectFileInfo(String user, String fileId, String revisionId) {
        this.user = Objects.requireNonNull(user);
        this.fileId = Objects.requireNonNull(fileId);
        this.revisionId = revisionId;
    }

    public String getUser() {
        return this.user;
    }

    public String getFileId() {
        return this.fileId;
    }

    public Optional<String> getRevisionId() {
        return Optional.ofNullable(this.revisionId);
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((Object)this);
        helper.add("user", (Object)this.user);
        helper.add("fileId", (Object)this.fileId);
        this.getRevisionId().ifPresent(rev -> helper.add("revisionId", rev));
        return helper.toString();
    }
}

