/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.cluster;

import java.time.Duration;
import java.time.Instant;
import java.util.Random;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.runtime.RuntimeServiceException;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.cluster.ClusterNodeDescriptor;
import org.nuxeo.runtime.cluster.ClusterService;
import org.nuxeo.runtime.kv.KeyValueService;
import org.nuxeo.runtime.kv.KeyValueStore;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class ClusterServiceImpl
extends DefaultComponent
implements ClusterService {
    private static final Logger log = LogManager.getLogger(ClusterServiceImpl.class);
    public static final int APPLICATION_STARTED_ORDER = -1000;
    public static final String XP_CONFIG = "configuration";
    public static final String CLUSTERING_ENABLED_OLD_PROP = "repository.clustering.enabled";
    public static final String NODE_ID_OLD_PROP = "repository.clustering.id";
    protected static final Random RANDOM = new Random();
    protected boolean enabled;
    protected String nodeId;

    public int getApplicationStartedOrder() {
        return -1000;
    }

    public void start(ComponentContext context) {
        String id;
        ClusterNodeDescriptor descr = (ClusterNodeDescriptor)this.getDescriptor(XP_CONFIG, "");
        Boolean enabledProp = descr == null ? null : descr.getEnabled();
        this.enabled = enabledProp != null ? enabledProp : Framework.isBooleanPropertyTrue((String)CLUSTERING_ENABLED_OLD_PROP);
        String string = id = descr == null ? null : (String)StringUtils.defaultIfBlank((CharSequence)descr.getName(), null);
        if (id != null) {
            this.nodeId = id.trim();
        } else {
            id = Framework.getProperty((String)NODE_ID_OLD_PROP);
            if (StringUtils.isNotBlank((CharSequence)id)) {
                this.nodeId = id.trim();
            } else {
                long l;
                while ((l = RANDOM.nextLong()) < 0L) {
                }
                this.nodeId = String.valueOf(l);
                if (this.enabled) {
                    log.warn("Missing cluster node id configuration, please define it explicitly. Using random cluster node id instead: {}", (Object)this.nodeId);
                } else {
                    log.info("Using random cluster node id: {}", (Object)this.nodeId);
                }
            }
        }
        super.start(context);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String nodeId) {
        if (!Framework.isTestModeSet()) {
            throw new UnsupportedOperationException("test mode only");
        }
        this.nodeId = nodeId;
    }

    @Override
    public void runAtomically(String key, Duration duration, Duration pollDelay, Runnable runnable) {
        if (!this.isEnabled()) {
            runnable.run();
            return;
        }
        new ClusterLockHelper(this.getNodeId(), duration, pollDelay).runAtomically(key, runnable);
    }

    public static class ClusterLockHelper {
        private static final Logger log = LogManager.getLogger(ClusterLockHelper.class);
        public static final String KV_STORE_NAME = "cluster";
        private static final int TTL_MULTIPLIER = 10;
        protected final String nodeId;
        protected final Duration duration;
        protected final Duration pollDelay;
        protected final KeyValueStore kvStore;

        public ClusterLockHelper(String nodeId, Duration duration, Duration pollDelay) {
            this.nodeId = nodeId;
            this.duration = duration;
            this.pollDelay = pollDelay;
            this.kvStore = ((KeyValueService)Framework.getService(KeyValueService.class)).getKeyValueStore(KV_STORE_NAME);
        }

        public void runAtomically(String key, Runnable runnable) {
            this.runInSeparateTransaction(() -> this.runAtomicallyInternal(key, runnable));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void runInSeparateTransaction(Runnable runnable) {
            boolean transaction = TransactionHelper.isTransactionActiveOrMarkedRollback();
            if (transaction) {
                TransactionHelper.commitOrRollbackTransaction();
            }
            boolean completedAbruptly = true;
            try {
                if (transaction) {
                    TransactionHelper.runInTransaction((Runnable)runnable);
                } else {
                    runnable.run();
                }
                completedAbruptly = false;
            }
            finally {
                if (transaction) {
                    try {
                        TransactionHelper.startTransaction();
                    }
                    finally {
                        if (completedAbruptly) {
                            TransactionHelper.setTransactionRollbackOnly();
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void runAtomicallyInternal(String key, Runnable runnable) {
            String lockInfo = this.tryLock(key);
            if (lockInfo != null) {
                try {
                    runnable.run();
                }
                finally {
                    this.unLock(key, lockInfo);
                }
            } else {
                throw new RuntimeServiceException("Failed to acquire lock '" + key + "' after " + this.duration.toSeconds() + "s, owner: " + this.getLock(key));
            }
        }

        protected String tryLock(String key) {
            log.debug("Trying to lock '{}'", (Object)key);
            long deadline = System.nanoTime() + this.duration.toNanos();
            long ttl = this.duration.multipliedBy(10L).toSeconds();
            do {
                String lockInfo;
                if (this.kvStore.compareAndSet(key, null, lockInfo = "node=" + this.nodeId + " time=" + Instant.now(), ttl)) {
                    log.debug("Lock '{}' acquired after {}ms", new Supplier[]{() -> key, () -> (System.nanoTime() - (deadline - this.duration.toNanos())) / 1000000L});
                    return lockInfo;
                }
                Supplier[] supplierArray = new Supplier[2];
                supplierArray[0] = () -> key;
                supplierArray[1] = this.pollDelay::toMillis;
                log.debug("  Sleeping on busy lock '{}' for {}ms", supplierArray);
                try {
                    Thread.sleep(this.pollDelay.toMillis());
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeServiceException((Throwable)e);
                }
            } while (System.nanoTime() < deadline);
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = () -> key;
            supplierArray[1] = this.duration::toSeconds;
            log.debug("Failed to acquire lock '{}' after {}s", supplierArray);
            return null;
        }

        protected void unLock(String key, String lockInfo) {
            log.debug("Unlocking '{}'", (Object)key);
            if (this.kvStore.compareAndSet(key, lockInfo, null)) {
                return;
            }
            String current = this.kvStore.getString(key);
            if (current == null) {
                log.warn("Unlocking '{}' but the lock had already expired; consider increasing the try duration for this lock", (Object)key);
            } else {
                log.error("Failed to unlock '{}', the lock expired and has a new owner: {}; consider increasing the try duration for this lock", (Object)key, (Object)this.getLock(key));
            }
        }

        protected String getLock(String key) {
            return this.kvStore.getString(key);
        }
    }
}

