/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.mongodb;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoDatabase;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.mongodb.MongoDBConnectionConfig;
import org.nuxeo.runtime.mongodb.MongoDBConnectionHelper;
import org.nuxeo.runtime.mongodb.MongoDBConnectionService;

public class MongoDBComponent
extends DefaultComponent
implements MongoDBConnectionService {
    private static final Logger log = LogManager.getLogger(MongoDBComponent.class);
    public static final String COMPONENT_NAME = "org.nuxeo.runtime.mongodb.MongoDBComponent";
    private static final String XP_CONNECTION = "connection";
    private static final String DEFAULT_CONNECTION_ID = "default";
    private final Map<String, MongoClient> clients = new ConcurrentHashMap<String, MongoClient>();

    public void start(ComponentContext context) {
        super.start(context);
        List confs = this.getDescriptors(XP_CONNECTION);
        confs.forEach(c -> {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = c::getId;
            log.debug("Initializing MongoClient with id={}", supplierArray);
            this.clients.put(c.getId(), MongoDBConnectionHelper.newMongoClient(c));
        });
    }

    public void stop(ComponentContext context) throws InterruptedException {
        super.stop(context);
        this.clients.entrySet().forEach(e -> {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = e::getKey;
            log.debug("Closing MongoClient with id={}", supplierArray);
            ((MongoClient)e.getValue()).close();
        });
        this.clients.clear();
    }

    public int getApplicationStartedOrder() {
        return 90;
    }

    @Override
    public MongoClient getClient(String id) {
        MongoClient client = this.clients.get(id);
        if (client == null) {
            client = this.clients.get(DEFAULT_CONNECTION_ID);
        }
        return client;
    }

    @Override
    public MongoDBConnectionConfig getConfig(String id) {
        MongoDBConnectionConfig config = (MongoDBConnectionConfig)this.getDescriptor(XP_CONNECTION, id);
        if (config == null) {
            config = (MongoDBConnectionConfig)this.getDescriptor(XP_CONNECTION, DEFAULT_CONNECTION_ID);
        }
        return config;
    }

    @Override
    public String getDatabaseName(String id) {
        return this.getConfig((String)id).dbname;
    }

    @Override
    public MongoDatabase getDatabase(String id) {
        MongoClient client = this.getClient(id);
        String dbname = this.getDatabaseName(id);
        return MongoDBConnectionHelper.getDatabase(client, dbname);
    }

    @Override
    public Iterable<MongoDatabase> getDatabases() {
        return () -> this.clients.entrySet().stream().map(e -> {
            MongoDBConnectionConfig c = (MongoDBConnectionConfig)this.getDescriptor(XP_CONNECTION, (String)e.getKey());
            return MongoDBConnectionHelper.getDatabase((MongoClient)e.getValue(), c.dbname);
        }).iterator();
    }
}

