/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.mongodb;

import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeMap;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.runtime.model.Descriptor;

@XObject(value="connection")
public class MongoDBConnectionConfig
implements Descriptor {
    @XNode(value="@id")
    public String id;
    @XNode(value="server")
    public String server;
    @XNode(value="ssl")
    public Boolean ssl;
    @XNode(value="trustStorePath")
    public String trustStorePath;
    @XNode(value="trustStorePassword")
    public String trustStorePassword;
    @XNode(value="trustStoreType")
    public String trustStoreType;
    @XNode(value="keyStorePath")
    public String keyStorePath;
    @XNode(value="keyStorePassword")
    public String keyStorePassword;
    @XNode(value="keyStoreType")
    public String keyStoreType;
    @XNode(value="dbname")
    public String dbname;
    @XNode(value="maxTime")
    public Duration maxTime;
    @XNodeMap(value="property", key="@name", type=HashMap.class, componentType=String.class)
    public Map<String, String> properties = new HashMap<String, String>();

    public String getId() {
        return this.id;
    }

    public MongoDBConnectionConfig merge(Descriptor o) {
        MongoDBConnectionConfig other = (MongoDBConnectionConfig)o;
        MongoDBConnectionConfig merged = new MongoDBConnectionConfig();
        merged.id = this.id;
        merged.server = StringUtils.defaultString((String)other.server, (String)this.server);
        merged.ssl = other.ssl != null ? other.ssl : this.ssl;
        merged.trustStorePath = StringUtils.defaultString((String)other.trustStorePath, (String)this.trustStorePath);
        merged.trustStorePassword = StringUtils.defaultString((String)other.trustStorePassword, (String)this.trustStorePassword);
        merged.trustStoreType = StringUtils.defaultString((String)other.trustStoreType, (String)this.trustStoreType);
        merged.keyStorePath = StringUtils.defaultString((String)other.keyStorePath, (String)this.keyStorePath);
        merged.keyStorePassword = StringUtils.defaultString((String)other.keyStorePassword, (String)this.keyStorePassword);
        merged.keyStoreType = StringUtils.defaultString((String)other.keyStoreType, (String)this.keyStoreType);
        merged.dbname = StringUtils.defaultString((String)other.dbname, (String)this.dbname);
        merged.maxTime = other.maxTime != null ? other.maxTime : this.maxTime;
        merged.properties.putAll(this.properties);
        merged.properties.putAll(other.properties);
        return merged;
    }
}

