/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.mongodb;

import com.mongodb.MongoClientSettings;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.nuxeo.runtime.mongodb.MongoDBConnectionConfig;
import org.nuxeo.runtime.mongodb.MongoDBConnectionHelper;

public class TestMongoDBConnectionHelper {
    @Test
    public void testPopulateProperties() {
        MongoClientSettings.Builder settingsBuilder = MongoClientSettings.builder().applicationName("properties-tester");
        MongoDBConnectionConfig config = new MongoDBConnectionConfig();
        config.properties = Map.of("readPreference", "primary", "readConcern", "majority", "writeConcern", "acknowledged");
        MongoDBConnectionHelper.populateProperties((MongoDBConnectionConfig)config, (MongoClientSettings.Builder)settingsBuilder);
        MongoClientSettings settings = settingsBuilder.build();
        Assert.assertEquals((Object)ReadPreference.primary(), (Object)settings.getReadPreference());
        Assert.assertEquals((Object)ReadConcern.MAJORITY, (Object)settings.getReadConcern());
        Assert.assertEquals((Object)WriteConcern.ACKNOWLEDGED, (Object)settings.getWriteConcern());
    }
}

