/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.osgi.application.loader;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.Environment;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.osgi.BundleFile;
import org.nuxeo.osgi.BundleImpl;
import org.nuxeo.osgi.DirectoryBundleFile;
import org.nuxeo.osgi.JarBundleFile;
import org.nuxeo.osgi.OSGiAdapter;
import org.nuxeo.osgi.SystemBundle;
import org.nuxeo.osgi.SystemBundleFile;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;

public class FrameworkLoader {
    public static final String HOST_NAME = "org.nuxeo.app.host.name";
    public static final String HOST_VERSION = "org.nuxeo.app.host.version";
    @Deprecated
    public static final String TMP_DIR = "org.nuxeo.app.tmp";
    public static final String LIBS = "org.nuxeo.app.libs";
    public static final String BUNDLES = "org.nuxeo.app.bundles";
    public static final String DEVMODE = "org.nuxeo.app.devmode";
    public static final String PREPROCESSING = "org.nuxeo.app.preprocessing";
    public static final String SCAN_FOR_NESTED_JARS = "org.nuxeo.app.scanForNestedJars";
    public static final String FLUSH_CACHE = "org.nuxeo.app.flushCache";
    public static final String ARGS = "org.nuxeo.app.args";
    private static final Log log = LogFactory.getLog(FrameworkLoader.class);
    private static boolean isInitialized;
    private static boolean isStarted;
    private static File home;
    private static ClassLoader loader;
    private static List<File> bundleFiles;
    private static OSGiAdapter osgi;
    protected static Attributes.Name SYMBOLIC_NAME;

    public static OSGiAdapter osgi() {
        return osgi;
    }

    public static ClassLoader getLoader() {
        return loader;
    }

    public static synchronized void initialize(ClassLoader cl, File home, List<File> bundleFiles, Map<String, Object> hostEnv) {
        if (isInitialized) {
            return;
        }
        FrameworkLoader.home = home;
        FrameworkLoader.bundleFiles = bundleFiles == null ? new ArrayList() : bundleFiles;
        Collections.sort(FrameworkLoader.bundleFiles);
        loader = cl;
        FrameworkLoader.doInitialize(hostEnv);
        osgi = new OSGiAdapter(home);
        isInitialized = true;
    }

    public static synchronized void start() throws BundleException {
        if (isStarted) {
            return;
        }
        if (!isInitialized) {
            throw new IllegalStateException("Framework is not initialized. Call initialize method first");
        }
        try {
            FrameworkLoader.doStart();
        }
        finally {
            isStarted = true;
        }
    }

    public static synchronized void stop() throws BundleException {
        if (!isStarted) {
            return;
        }
        try {
            FrameworkLoader.doStop();
        }
        finally {
            isStarted = false;
        }
    }

    private static void doInitialize(Map<String, Object> hostEnv) {
        boolean doPreprocessing = true;
        String v = (String)hostEnv.get(PREPROCESSING);
        if (v != null) {
            doPreprocessing = Boolean.parseBoolean(v);
        }
        Environment env = FrameworkLoader.createEnvironment(home, hostEnv);
        Environment.setDefault((Environment)env);
        FrameworkLoader.loadSystemProperties();
        if (doPreprocessing) {
            try {
                FrameworkLoader.preprocess();
            }
            catch (RuntimeException e) {
                throw new RuntimeException("Failed to run preprocessing", e);
            }
        }
    }

    protected static void printDeploymentOrderInfo(List<File> files) {
        if (log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            for (File file : files) {
                if (file == null) continue;
                sb.append("\n\t").append(file.getPath());
            }
            log.debug((Object)("Deployment order: " + sb.toString()));
        }
    }

    protected static boolean isBundle(File f) {
        Manifest mf;
        block17: {
            try {
                if (f.isFile()) {
                    try (JarFile jf = new JarFile(f);){
                        mf = jf.getManifest();
                    }
                    if (mf == null) {
                        return false;
                    }
                    break block17;
                }
                if (f.isDirectory()) {
                    if (!(f = new File(f, "META-INF/MANIFEST.MF")).isFile()) {
                        return false;
                    }
                    mf = new Manifest();
                    try (FileInputStream input = new FileInputStream(f);){
                        mf.read(input);
                        break block17;
                    }
                }
                return false;
            }
            catch (IOException e) {
                return false;
            }
        }
        return mf.getMainAttributes().containsKey(SYMBOLIC_NAME);
    }

    private static void doStart() throws BundleException {
        SystemBundleFile bf;
        FrameworkLoader.printStartMessage();
        try {
            bf = new SystemBundleFile(home);
        }
        catch (IOException e) {
            throw new BundleException("Cannot create system bundle for " + home, (Throwable)e);
        }
        SystemBundle systemBundle = new SystemBundle(osgi, bf, loader);
        osgi.setSystemBundle(systemBundle);
        FrameworkLoader.printDeploymentOrderInfo(bundleFiles);
        for (File f : bundleFiles) {
            if (!FrameworkLoader.isBundle(f)) continue;
            try {
                FrameworkLoader.install(f);
            }
            catch (IOException | RuntimeException | BundleException e) {
                log.error((Object)("Failed to install bundle: " + f), e);
            }
        }
        osgi.fireFrameworkEvent(new FrameworkEvent(1, (Bundle)systemBundle, null));
    }

    private static void doStop() throws BundleException {
        try {
            osgi.shutdown();
        }
        catch (IOException e) {
            throw new BundleException("Cannot shutdown OSGi", (Throwable)e);
        }
    }

    public static void uninstall(String symbolicName) throws BundleException {
        BundleImpl bundle = osgi.getBundle(symbolicName);
        if (bundle != null) {
            bundle.uninstall();
        }
    }

    public static String install(File f) throws IOException, BundleException {
        BundleFile bf = f.isDirectory() ? new DirectoryBundleFile(f) : new JarBundleFile(f);
        BundleImpl bundle = new BundleImpl(osgi, bf, loader);
        if (bundle.getState() == 0) {
            return null;
        }
        osgi.install(bundle);
        return bundle.getSymbolicName();
    }

    public static void preprocess() {
        File f = new File(home, "OSGI-INF/deployment-container.xml");
        if (!f.isFile()) {
            return;
        }
        try {
            Class<?> klass = loader.loadClass("org.nuxeo.runtime.deployment.preprocessor.DeploymentPreprocessor");
            Method main = klass.getMethod("main", String[].class);
            main.invoke(null, new Object[]{new String[]{home.getAbsolutePath()}});
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    protected static void loadSystemProperties() {
        File file = new File(home, "system.properties");
        if (!file.isFile()) {
            return;
        }
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            Properties p = new Properties();
            p.load(in);
            for (Map.Entry<Object, Object> entry : p.entrySet()) {
                String v = (String)entry.getValue();
                v = StringUtils.expandVars((String)v, (Map)System.getProperties());
                System.setProperty((String)entry.getKey(), v);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load system properties", e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    log.error((Object)e);
                }
            }
        }
    }

    protected static String getEnvProperty(String key, Map<String, Object> hostEnv, Properties sysprops, boolean addToSystemProperties) {
        String v = (String)hostEnv.get(key);
        if (v == null) {
            v = System.getProperty(key);
        }
        if (v != null) {
            v = StringUtils.expandVars((String)v, (Map)sysprops);
            if (addToSystemProperties) {
                sysprops.setProperty(key, v);
            }
        }
        return v;
    }

    protected static Environment createEnvironment(File home, Map<String, Object> hostEnv) {
        String v;
        Properties sysprops = System.getProperties();
        sysprops.setProperty("nuxeo.runtime.home", home.getAbsolutePath());
        Environment env = Environment.getDefault();
        if (env == null) {
            env = new Environment(home);
        }
        if (!home.equals(env.getRuntimeHome())) {
            env.setRuntimeHome(home);
        }
        env.setHostApplicationName((v = (String)hostEnv.get(HOST_NAME)) == null ? "NXServer" : v);
        v = (String)hostEnv.get(HOST_VERSION);
        if (v != null) {
            env.setHostApplicationVersion((String)hostEnv.get(HOST_VERSION));
        }
        if ((v = FrameworkLoader.getEnvProperty("nuxeo.data.dir", hostEnv, sysprops, true)) != null) {
            env.setData(new File(v));
        } else {
            sysprops.setProperty("nuxeo.data.dir", env.getData().getAbsolutePath());
        }
        v = FrameworkLoader.getEnvProperty("nuxeo.log.dir", hostEnv, sysprops, true);
        if (v != null) {
            env.setLog(new File(v));
        } else {
            sysprops.setProperty("nuxeo.log.dir", env.getLog().getAbsolutePath());
        }
        v = FrameworkLoader.getEnvProperty("nuxeo.tmp.dir", hostEnv, sysprops, true);
        if (v != null) {
            env.setTemp(new File(v));
        } else {
            sysprops.setProperty("nuxeo.tmp.dir", env.getTemp().getAbsolutePath());
        }
        v = FrameworkLoader.getEnvProperty("nuxeo.config.dir", hostEnv, sysprops, true);
        if (v != null) {
            env.setConfig(new File(v));
        } else {
            sysprops.setProperty("nuxeo.config.dir", env.getConfig().getAbsolutePath());
        }
        v = FrameworkLoader.getEnvProperty("nuxeo.web.dir", hostEnv, sysprops, true);
        if (v != null) {
            env.setWeb(new File(v));
        } else {
            sysprops.setProperty("nuxeo.web.dir", env.getWeb().getAbsolutePath());
        }
        v = (String)hostEnv.get(ARGS);
        if (v != null) {
            env.setCommandLineArguments(v.split("\\s+"));
        } else {
            env.setCommandLineArguments(new String[0]);
        }
        return env;
    }

    protected static void printStartMessage() {
        StringBuilder msg = FrameworkLoader.getStartMessage();
        log.info((Object)msg);
    }

    protected static StringBuilder getStartMessage() {
        String newline = System.getProperty("line.separator");
        Environment env = Environment.getDefault();
        String hr = "======================================================================";
        StringBuilder msg = new StringBuilder(newline);
        msg.append(hr).append(newline);
        msg.append("= Starting Nuxeo Framework").append(newline);
        msg.append(hr).append(newline);
        msg.append("  * Server home = ").append(env.getServerHome()).append(newline);
        msg.append("  * Runtime home = ").append(env.getRuntimeHome()).append(newline);
        msg.append("  * Data Directory = ").append(env.getData()).append(newline);
        msg.append("  * Log Directory = ").append(env.getLog()).append(newline);
        msg.append("  * Configuration Directory = ").append(env.getConfig()).append(newline);
        msg.append("  * Temp Directory = ").append(env.getTemp()).append(newline);
        msg.append(hr);
        return msg;
    }

    static {
        SYMBOLIC_NAME = new Attributes.Name("Bundle-SymbolicName");
    }
}

