/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.redis;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.core.redis.RedisExecutor;
import org.nuxeo.ecm.core.redis.RedisFailoverExecutor;
import org.nuxeo.ecm.core.redis.RedisPoolDescriptor;
import org.nuxeo.ecm.core.redis.RedisPoolExecutor;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.util.Pool;

@XObject(value="server")
public class RedisServerDescriptor
extends RedisPoolDescriptor {
    @XNode(value="host")
    public String host;
    @XNode(value="port")
    public int port = 6379;
    @XNode(value="ssl")
    public boolean ssl;
    @XNode(value="trustStorePath")
    public String trustStorePath;
    @XNode(value="trustStorePassword")
    public String trustStorePassword;
    @XNode(value="trustStoreType")
    public String trustStoreType;
    @XNode(value="keyStorePath")
    public String keyStorePath;
    @XNode(value="keyStorePassword")
    public String keyStorePassword;
    @XNode(value="keyStoreType")
    public String keyStoreType;
    @XNode(value="failoverTimeout")
    public int failoverTimeout = 300;

    @Override
    public RedisExecutor newExecutor() {
        SSLSocketFactory sslSocketFactory;
        boolean useSSL;
        SSLContext sslContext = this.getSSLContext();
        if (sslContext == null) {
            useSSL = this.ssl;
            sslSocketFactory = null;
        } else {
            useSSL = true;
            sslSocketFactory = sslContext.getSocketFactory();
        }
        try (Jedis jedis = new Jedis(this.host, this.port, useSSL, sslSocketFactory, null, null);){
            String pong;
            if (StringUtils.isNotBlank((CharSequence)this.password)) {
                jedis.auth(this.password);
            }
            if (!"PONG".equals(pong = jedis.ping())) {
                throw new RuntimeException("Cannot connect to Redis host: " + this.host + ":" + this.port);
            }
        }
        JedisPoolConfig conf = new JedisPoolConfig();
        conf.setMaxTotal(this.maxTotal);
        conf.setMaxIdle(this.maxIdle);
        RedisPoolExecutor base = new RedisPoolExecutor((Pool<Jedis>)new JedisPool((GenericObjectPoolConfig)conf, this.host, this.port, this.timeout, (String)StringUtils.defaultIfBlank((CharSequence)this.password, null), this.database));
        return new RedisFailoverExecutor(this.failoverTimeout, base);
    }

    protected SSLContext getSSLContext() {
        try {
            KeyStore trustStore = this.loadKeyStore(this.trustStorePath, this.trustStorePassword, this.trustStoreType);
            KeyStore keyStore = this.loadKeyStore(this.keyStorePath, this.keyStorePassword, this.keyStoreType);
            if (trustStore == null && keyStore == null) {
                return null;
            }
            SSLContextBuilder sslContextBuilder = SSLContexts.custom();
            if (trustStore != null) {
                sslContextBuilder.loadTrustMaterial(trustStore, null);
            }
            if (keyStore != null) {
                sslContextBuilder.loadKeyMaterial(keyStore, null);
            }
            return sslContextBuilder.build();
        }
        catch (IOException | GeneralSecurityException e) {
            throw new RuntimeException("Cannot setup SSL context", e);
        }
    }

    protected KeyStore loadKeyStore(String path, String password, String type) throws GeneralSecurityException, IOException {
        if (StringUtils.isBlank((CharSequence)path)) {
            return null;
        }
        String keyStoreType = (String)StringUtils.defaultIfBlank((CharSequence)type, (CharSequence)KeyStore.getDefaultType());
        KeyStore keyStore = KeyStore.getInstance(keyStoreType);
        char[] passwordChars = StringUtils.isBlank((CharSequence)password) ? null : password.toCharArray();
        try (InputStream is = Files.newInputStream(Paths.get(path, new String[0]), new OpenOption[0]);){
            keyStore.load(is, passwordChars);
        }
        return keyStore;
    }
}

