/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.test;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.runtime.AbstractRuntimeService;
import org.nuxeo.runtime.Version;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.impl.DefaultRuntimeContext;

public class TestRuntime
extends AbstractRuntimeService {
    private static final Log log = LogFactory.getLog(TestRuntime.class);
    public static final String NAME = "Test Runtime";
    public static final Version VERSION = Version.parseString((String)"1.0.0");
    private static int counter = 0;

    public TestRuntime() {
        super(new DefaultRuntimeContext());
        try {
            this.workingDir = Framework.createTempFile((String)"NXTestFramework", (String)TestRuntime.generateId());
            this.workingDir.delete();
        }
        catch (IOException e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    public String getName() {
        return NAME;
    }

    public Version getVersion() {
        return VERSION;
    }

    private static synchronized String generateId() {
        long stamp = System.currentTimeMillis();
        return Long.toHexString(stamp) + "-" + System.identityHashCode(System.class) + "." + ++counter;
    }

    public void deploy(URL url) throws Exception {
        this.context.deploy(url);
    }

    public void undeploy(URL url) throws Exception {
        this.context.undeploy(url);
    }

    public void stop() {
        try {
            super.stop();
        }
        finally {
            if (this.workingDir != null) {
                FileUtils.deleteQuietly((File)this.workingDir);
            }
        }
    }

    public void reloadProperties() {
        throw new UnsupportedOperationException("Not yet implemented");
    }
}

