/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.test.runner;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.Parameterized;
import org.junit.runners.ParentRunner;
import org.junit.runners.Suite;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerBuilder;
import org.junit.runners.model.TestClass;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.RunnerFeature;

public class ParameterizedSuite
extends ParentRunner<FeaturesRunner> {
    private final List<FeaturesRunner> runners = new ArrayList<FeaturesRunner>();
    private final Map<FeaturesRunner, Object[]> runnersParams = new HashMap<FeaturesRunner, Object[]>();
    private List<Object[]> parametersList;
    private Class<? extends RunnerFeature> parameterizedClass;

    private List<Object[]> getParametersList(TestClass klass) throws Throwable {
        return (List)this.getParametersMethod(klass).invokeExplosively(null, new Object[0]);
    }

    private Class<? extends RunnerFeature> getParameterizedClass(Class<?> klass) {
        ParameterizedFeature annotation = klass.getAnnotation(ParameterizedFeature.class);
        return annotation != null ? annotation.value() : null;
    }

    private FrameworkMethod getParametersMethod(TestClass testClass) throws Exception {
        List methods = testClass.getAnnotatedMethods(Parameterized.Parameters.class);
        for (FrameworkMethod each : methods) {
            int modifiers = each.getMethod().getModifiers();
            if (!Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers)) continue;
            return each;
        }
        throw new Exception("Missing public static Parameters method on class " + testClass.getName());
    }

    public ParameterizedSuite(Class<?> testClass, RunnerBuilder builder) throws InitializationError {
        this(builder, testClass, ParameterizedSuite.getSuiteClasses(testClass));
    }

    public ParameterizedSuite(RunnerBuilder builder, Class<?> testClass, Class<?>[] classes) throws InitializationError {
        super(testClass);
        try {
            this.parametersList = this.getParametersList(this.getTestClass());
            this.parameterizedClass = this.getParameterizedClass(testClass);
        }
        catch (Throwable e) {
            throw new InitializationError(e);
        }
        for (Object[] params : this.parametersList) {
            List runners2 = builder.runners(testClass, (Class[])classes);
            for (Runner runner : runners2) {
                if (!(runner instanceof FeaturesRunner)) continue;
                FeaturesRunner featureRunner = (FeaturesRunner)runner;
                this.runners.add(featureRunner);
                try {
                    if (this.parameterizedClass == null) continue;
                    this.runnersParams.put(featureRunner, params);
                    RunnerFeature feature = featureRunner.getFeature(this.parameterizedClass);
                    for (Method method : feature.getClass().getMethods()) {
                        if (method.getAnnotation(ParameterizedMethod.class) == null) continue;
                        method.invoke((Object)feature, new Object[]{params});
                    }
                }
                catch (Throwable e) {
                    throw new InitializationError(e);
                }
            }
        }
    }

    protected static Class<?>[] getSuiteClasses(Class<?> klass) throws InitializationError {
        Suite.SuiteClasses annotation = klass.getAnnotation(Suite.SuiteClasses.class);
        if (annotation == null) {
            throw new InitializationError(String.format("class '%s' must have a SuiteClasses annotation", klass.getName()));
        }
        return annotation.value();
    }

    protected Description describeChild(FeaturesRunner child) {
        Description description = child.getDescription();
        return Description.createTestDescription((Class)description.getTestClass(), (String)(description.getDisplayName() + " " + Arrays.toString(this.runnersParams.get((Object)child))), (Annotation[])description.getAnnotations().toArray(new Annotation[0]));
    }

    protected List<FeaturesRunner> getChildren() {
        return this.runners;
    }

    protected void runChild(FeaturesRunner child, RunNotifier notifier) {
        System.out.println(String.format("\r\n============= RUNNING %s =================", this.describeChild(child)));
        child.run(notifier);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface ParameterizedMethod {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    @Inherited
    public static @interface ParameterizedFeature {
        public Class<?> value();
    }
}

