/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.test.runner;

import java.util.Properties;
import org.junit.runners.model.FrameworkMethod;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.RunnerFeature;
import org.nuxeo.runtime.test.runner.WithFrameworkProperty;

public class WithFrameworkPropertyFeature
implements RunnerFeature {
    protected Properties previousProperties = new Properties();

    @Override
    public void beforeSetup(FeaturesRunner runner, FrameworkMethod method, Object test) {
        Properties properties = Framework.getProperties();
        for (WithFrameworkProperty annot : (WithFrameworkProperty[])method.getMethod().getAnnotationsByType(WithFrameworkProperty.class)) {
            String propertyKey = annot.name();
            Object previousProperty = properties.remove(propertyKey);
            if (previousProperty != null) {
                this.previousProperties.put(propertyKey, previousProperty);
            }
            properties.put(propertyKey, annot.value());
        }
    }

    @Override
    public void afterTeardown(FeaturesRunner runner, FrameworkMethod method, Object test) {
        Properties properties = Framework.getProperties();
        for (WithFrameworkProperty annot : (WithFrameworkProperty[])method.getMethod().getAnnotationsByType(WithFrameworkProperty.class)) {
            String propertyKey = annot.name();
            if (this.previousProperties.contains(propertyKey)) {
                properties.put(propertyKey, this.previousProperties.get(propertyKey));
                continue;
            }
            properties.remove(propertyKey);
        }
        this.previousProperties.clear();
    }
}

