/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.test.runner.web;

import com.gargoylesoftware.htmlunit.AjaxController;
import com.gargoylesoftware.htmlunit.NicelyResynchronizingAjaxController;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.attachment.AttachmentHandler;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.UnaryOperator;
import org.nuxeo.runtime.test.runner.web.Attachment;
import org.nuxeo.runtime.test.runner.web.DriverFactory;
import org.nuxeo.runtime.test.runner.web.TakesAttachment;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.remote.DesiredCapabilities;

public enum BrowserFamily {
    FIREFOX,
    IE,
    CHROME,
    HTML_UNIT,
    HTML_UNIT_JS;


    public DriverFactory getDriverFactory() {
        switch (this) {
            case FIREFOX: {
                return new FirefoxDriverFactory();
            }
            case IE: {
                return new IEDriverFactory();
            }
            case CHROME: {
                return new ChromeDriverFactory();
            }
            case HTML_UNIT: {
                return new HtmlUnitDriverFactory();
            }
        }
        return new HtmlUnitJsDriverFactory();
    }

    class HtmlUnitJsDriverFactory
    extends HtmlUnitDriverFactory {
        HtmlUnitJsDriverFactory() {
        }

        @Override
        boolean jsEnabled() {
            return true;
        }

        @Override
        UnaryOperator<WebClient> customizer() {
            UnaryOperator setJavascript = client -> {
                client.getOptions().setThrowExceptionOnScriptError(false);
                client.setAjaxController((AjaxController)new NicelyResynchronizingAjaxController());
                return client;
            };
            return client -> (WebClient)setJavascript.apply((WebClient)super.customizer().apply((WebClient)client));
        }

        @Override
        public void waitForAjax(WebDriver driver) {
            ((HtmlUnitDriverFactory.CustomizableHtmlUnitDriver)driver).getWebClient().waitForBackgroundJavaScript(30000L);
        }
    }

    class HtmlUnitDriverFactory
    implements DriverFactory {
        Attachment attachment;
        final AttachmentHandler attachmentHandler = new AttachmentHandler(){

            public void handleAttachment(final Page page) {
                HtmlUnitDriverFactory.this.attachment = new Attachment(){

                    @Override
                    public String getFilename() {
                        String filename = this.getSuggestedFilename();
                        if (filename != null) {
                            return filename;
                        }
                        String path = page.getUrl().getPath();
                        return path.substring(path.lastIndexOf(47) + 1);
                    }

                    @Override
                    public InputStream getContent() throws IOException {
                        return page.getWebResponse().getContentAsStream();
                    }

                    public String getSuggestedFilename() {
                        WebResponse response = page.getWebResponse();
                        String disp = response.getResponseHeaderValue("Content-Disposition");
                        int start = disp.indexOf("filename=");
                        if (start == -1) {
                            return null;
                        }
                        int end = disp.indexOf(59, start += "filename=".length());
                        if (end == -1) {
                            end = disp.length();
                        }
                        if (disp.charAt(start) == '\"' && disp.charAt(end - 1) == '\"') {
                            ++start;
                            --end;
                        }
                        return disp.substring(start, end);
                    }
                };
            }
        };

        HtmlUnitDriverFactory() {
        }

        UnaryOperator<WebClient> customizer() {
            return client -> {
                client.setAttachmentHandler(this.attachmentHandler);
                return client;
            };
        }

        boolean jsEnabled() {
            return false;
        }

        @Override
        public WebDriver createDriver() {
            return new CustomizableHtmlUnitDriver();
        }

        @Override
        public void disposeDriver(WebDriver driver) {
        }

        @Override
        public BrowserFamily getBrowserFamily() {
            return BrowserFamily.this;
        }

        @Override
        public void waitForAjax(WebDriver driver) {
        }

        class CustomizableHtmlUnitDriver
        extends HtmlUnitDriver
        implements TakesAttachment {
            public WebClient getWebClient() {
                return super.getWebClient();
            }

            protected CustomizableHtmlUnitDriver() {
                super(HtmlUnitDriverFactory.this.jsEnabled());
            }

            protected WebClient modifyWebClient(WebClient client) {
                return (WebClient)HtmlUnitDriverFactory.this.customizer().apply(client);
            }

            @Override
            public Attachment getAttachment() throws WebDriverException {
                return HtmlUnitDriverFactory.this.attachment;
            }
        }
    }

    class IEDriverFactory
    implements DriverFactory {
        IEDriverFactory() {
        }

        @Override
        public WebDriver createDriver() {
            InternetExplorerDriver driver = new InternetExplorerDriver();
            return driver;
        }

        @Override
        public void disposeDriver(WebDriver driver) {
        }

        @Override
        public BrowserFamily getBrowserFamily() {
            return BrowserFamily.this;
        }
    }

    class ChromeDriverFactory
    implements DriverFactory {
        ChromeDriverFactory() {
        }

        @Override
        public WebDriver createDriver() {
            ChromeDriver ff = new ChromeDriver();
            return ff;
        }

        @Override
        public void disposeDriver(WebDriver driver) {
        }

        @Override
        public BrowserFamily getBrowserFamily() {
            return BrowserFamily.this;
        }
    }

    class FirefoxDriverFactory
    implements DriverFactory {
        FirefoxDriverFactory() {
        }

        @Override
        public WebDriver createDriver() {
            FirefoxProfile profile = new FirefoxProfile();
            String dir = "target/downloads";
            profile.setPreference("browser.download.defaultFolder", dir);
            profile.setPreference("browser.download.downloadDir", dir);
            profile.setPreference("browser.download.lastDir", dir);
            profile.setPreference("browser.download.dir", dir);
            profile.setPreference("browser.download.useDownloadDir", "true");
            profile.setPreference("browser.helperApps.neverAsk.saveToDisk", "text/json");
            profile.setPreference("browser.download.folderList", 2);
            profile.setPreference("browser.download manager.useWindow", "false");
            DesiredCapabilities dc = DesiredCapabilities.firefox();
            dc.setCapability("firefox_profile", (Object)profile);
            return new FirefoxDriver((Capabilities)dc);
        }

        @Override
        public void disposeDriver(WebDriver driver) {
        }

        @Override
        public BrowserFamily getBrowserFamily() {
            return BrowserFamily.this;
        }
    }
}

