/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.test.runner.web;

import org.nuxeo.runtime.test.runner.web.BrowserFamily;
import org.nuxeo.runtime.test.runner.web.DriverFactory;
import org.nuxeo.runtime.test.runner.web.WebPage;
import org.openqa.selenium.WebDriver;

public class Configuration {
    protected WebDriver driver;
    protected DriverFactory factory;
    protected int port;
    protected String home;
    protected Class<? extends WebPage> homePageClass;
    protected static final String PORT_PLACEHOLDER = "${PORT}";

    public Configuration(DriverFactory factory) {
        this.factory = factory;
    }

    protected WebDriver createDriver() {
        return this.factory.createDriver();
    }

    protected void disposeDriver(WebDriver driver) {
        this.factory.disposeDriver(driver);
    }

    public BrowserFamily getBrowserFamily() {
        return this.factory.getBrowserFamily();
    }

    public void setFactory(DriverFactory factory) {
        this.resetDriver();
        this.factory = factory;
    }

    public DriverFactory getFactory() {
        return this.factory;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setHome(String url) {
        this.home = url;
    }

    public String getHome() {
        String url = this.home;
        if (url != null && url.contains(PORT_PLACEHOLDER)) {
            url = url.replace(PORT_PLACEHOLDER, String.valueOf(this.port));
        }
        return url;
    }

    public void setHomePageClass(Class<? extends WebPage> homePageClass) {
        this.homePageClass = homePageClass;
    }

    public Class<? extends WebPage> getHomePageClass() {
        return this.homePageClass;
    }

    public void home() {
        if (this.getHome() != null && this.driver != null) {
            this.driver.get(this.getHome());
        }
    }

    public WebDriver getDriver() {
        if (this.driver == null) {
            this.driver = this.createDriver();
            this.home();
        }
        return this.driver;
    }

    public void resetDriver() {
        if (this.driver != null) {
            this.driver.quit();
            this.disposeDriver(this.driver);
            this.driver = null;
        }
    }
}

