/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.template.api.descriptor;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.common.xmap.registry.XEnable;
import org.nuxeo.common.xmap.registry.XRegistry;
import org.nuxeo.common.xmap.registry.XRegistryId;
import org.nuxeo.template.api.context.ContextExtensionFactory;

@XObject(value="contextFactory")
@XRegistry(enable=false)
public class ContextExtensionFactoryDescriptor {
    protected static final Log log = LogFactory.getLog(ContextExtensionFactoryDescriptor.class);
    @XNode(value="@name")
    @XRegistryId
    protected String name;
    @XNode(value="@class")
    protected Class<? extends ContextExtensionFactory> factoryClass;
    @XNode(value="@enable", fallback="@enabled")
    @XEnable
    protected boolean enabled;
    @XNodeList(value="aliasName", type=ArrayList.class, componentType=String.class)
    protected List<String> aliasNames = new ArrayList<String>();
    protected ContextExtensionFactory factory;

    public ContextExtensionFactory getExtensionFactory() {
        if (this.factory == null && this.factoryClass != null) {
            try {
                this.factory = this.factoryClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                log.error((Object)"Unable to instanciate Processor", (Throwable)e);
            }
        }
        return this.factory;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getAliases() {
        return this.aliasNames;
    }
}

