/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.template.api.descriptor;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.common.xmap.registry.XEnable;
import org.nuxeo.common.xmap.registry.XMerge;
import org.nuxeo.common.xmap.registry.XRegistry;
import org.nuxeo.common.xmap.registry.XRegistryId;
import org.nuxeo.template.api.TemplateProcessor;

@XObject(value="templateProcessor")
@XRegistry(enable=false)
public class TemplateProcessorDescriptor {
    protected static final Log log = LogFactory.getLog(TemplateProcessorDescriptor.class);
    protected TemplateProcessor processor;
    @XNode(value="@name")
    @XRegistryId
    protected String name;
    @XNode(value="@label")
    protected String label;
    @XNode(value="@class")
    protected Class<?> className;
    @XNode(value="@default")
    protected boolean defaultProcessor = true;
    @XNode(value="@enable", fallback="@enabled")
    @XEnable
    protected boolean enabled;
    @XNodeList(value="supportedMimeType", type=ArrayList.class, componentType=String.class)
    @XMerge(value="@mergeSupportedMimeTypes")
    protected List<String> supportedMimeTypes = new ArrayList<String>();
    @XNodeList(value="supportedExtension", type=ArrayList.class, componentType=String.class)
    @XMerge(value="@mergeSupportedExtensions")
    protected List<String> supportedExtensions = new ArrayList<String>();

    public boolean init() {
        return this.getProcessor() == null;
    }

    public TemplateProcessor getProcessor() {
        if (this.processor == null && this.className != null) {
            try {
                this.processor = (TemplateProcessor)this.className.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                log.error((Object)"Unable to instanciate Processor", (Throwable)e);
            }
        }
        return this.processor;
    }

    public String getName() {
        return this.name;
    }

    public String getLabel() {
        return this.label;
    }

    public Class getClassName() {
        return this.className;
    }

    public List<String> getSupportedMimeTypes() {
        return this.supportedMimeTypes;
    }

    public List<String> getSupportedExtensions() {
        return this.supportedExtensions;
    }

    public boolean isDefaultProcessor() {
        return this.defaultProcessor;
    }
}

