/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.targetplatforms.api.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.targetplatforms.api.TargetPackageInfo;
import org.nuxeo.targetplatforms.api.TargetPlatformInfo;
import org.nuxeo.targetplatforms.api.impl.TargetInfoImpl;

public class TargetPlatformInfoImpl
extends TargetInfoImpl
implements TargetPlatformInfo {
    private static final long serialVersionUID = 1L;
    protected Map<String, TargetPackageInfo> availablePackagesInfo;

    protected TargetPlatformInfoImpl() {
    }

    public TargetPlatformInfoImpl(String id, String name, String version, String refVersion, String label) {
        super(id, name, version, refVersion, label);
    }

    @Override
    public List<String> getAvailablePackagesIds() {
        if (this.availablePackagesInfo == null) {
            return Collections.emptyList();
        }
        return new ArrayList<String>(this.availablePackagesInfo.keySet());
    }

    @Override
    public Map<String, TargetPackageInfo> getAvailablePackagesInfo() {
        if (this.availablePackagesInfo == null) {
            return Collections.emptyMap();
        }
        return new LinkedHashMap<String, TargetPackageInfo>(this.availablePackagesInfo);
    }

    @Override
    public void addAvailablePackageInfo(TargetPackageInfo packInfo) {
        if (packInfo == null) {
            return;
        }
        if (this.availablePackagesInfo == null) {
            this.availablePackagesInfo = new LinkedHashMap<String, TargetPackageInfo>();
        }
        this.availablePackagesInfo.put(packInfo.getId(), packInfo);
    }

    @Override
    public void setAvailablePackagesInfo(Map<String, TargetPackageInfo> packages) {
        if (this.availablePackagesInfo != null) {
            this.availablePackagesInfo.clear();
        }
        if (packages != null) {
            for (TargetPackageInfo packInfo : packages.values()) {
                this.addAvailablePackageInfo(packInfo);
            }
        }
    }

    @Override
    public int compareTo(TargetPlatformInfo o) {
        int comp = this.getName().compareTo(o.getName());
        if (comp == 0) {
            comp = this.getVersion().compareTo(o.getVersion());
        }
        return comp;
    }
}

