/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.targetplatforms.api.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.targetplatforms.api.TargetPackage;
import org.nuxeo.targetplatforms.api.TargetPlatform;
import org.nuxeo.targetplatforms.api.impl.TargetImpl;

public class TargetPlatformImpl
extends TargetImpl
implements TargetPlatform {
    private static final long serialVersionUID = 1L;
    protected TargetPlatform parent;
    protected Map<String, TargetPackage> availablePackages;
    protected List<String> testVersions;

    protected TargetPlatformImpl() {
    }

    public TargetPlatformImpl(String id) {
        super(id);
    }

    public TargetPlatformImpl(String id, String name, String version, String refVersion, String label) {
        super(id, name, version, refVersion, label);
    }

    @Override
    public List<String> getAvailablePackagesIds() {
        if (this.availablePackages == null) {
            return Collections.emptyList();
        }
        return new ArrayList<String>(this.availablePackages.keySet());
    }

    @Override
    public List<TargetPackage> getAvailablePackages() {
        if (this.availablePackages == null) {
            return Collections.emptyList();
        }
        return new ArrayList<TargetPackage>(this.availablePackages.values());
    }

    public void addAvailablePackage(TargetPackage pack) {
        if (pack == null) {
            return;
        }
        if (this.availablePackages == null) {
            this.availablePackages = new LinkedHashMap<String, TargetPackage>();
        }
        this.availablePackages.put(pack.getId(), pack);
    }

    public void setAvailablePackages(Map<String, TargetPackage> tps) {
        if (this.availablePackages == null) {
            this.availablePackages = new LinkedHashMap<String, TargetPackage>();
        } else {
            this.availablePackages.clear();
        }
        if (tps != null) {
            this.availablePackages.putAll(tps);
        }
    }

    @Override
    public TargetPlatform getParent() {
        return this.parent;
    }

    public void setParent(TargetPlatform parent) {
        this.parent = parent;
    }

    @Override
    public List<String> getTestVersions() {
        return this.testVersions;
    }

    public void setTestVersions(List<String> testVersions) {
        this.testVersions = testVersions == null ? testVersions : new ArrayList<String>(testVersions);
    }

    @Override
    public int compareTo(TargetPlatform o) {
        int comp = this.getName().compareTo(o.getName());
        if (comp == 0) {
            comp = this.getVersion().compareTo(o.getVersion());
        }
        return comp;
    }
}

