/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.quarkus.devui;

import ai.timefold.solver.core.api.domain.solution.cloner.SolutionCloner;
import ai.timefold.solver.core.api.solver.SolverFactory;
import ai.timefold.solver.core.config.solver.SolverConfig;
import ai.timefold.solver.core.config.solver.termination.TerminationConfig;
import ai.timefold.solver.core.impl.domain.common.accessor.MemberAccessor;
import ai.timefold.solver.core.impl.io.jaxb.SolverConfigIO;
import ai.timefold.solver.quarkus.config.SolverRuntimeConfig;
import ai.timefold.solver.quarkus.config.TimefoldRuntimeConfig;
import ai.timefold.solver.quarkus.devui.DevUISolverConfig;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;

@Recorder
public class TimefoldDevUIRecorder {
    public Supplier<DevUISolverConfig> solverConfigSupplier(Map<String, SolverConfig> allSolverConfig, TimefoldRuntimeConfig timefoldRuntimeConfig, Map<String, RuntimeValue<MemberAccessor>> generatedGizmoMemberAccessorMap, Map<String, RuntimeValue<SolutionCloner>> generatedGizmoSolutionClonerMap) {
        return () -> {
            DevUISolverConfig uiSolverConfig = new DevUISolverConfig();
            allSolverConfig.forEach((solverName, solverConfig) -> {
                this.updateSolverConfigWithRuntimeProperties((String)solverName, (SolverConfig)solverConfig, timefoldRuntimeConfig);
                HashMap memberAccessorMap = new HashMap();
                HashMap solutionClonerMap = new HashMap();
                generatedGizmoMemberAccessorMap.forEach((className, runtimeValue) -> memberAccessorMap.put(className, (MemberAccessor)runtimeValue.getValue()));
                generatedGizmoSolutionClonerMap.forEach((className, runtimeValue) -> solutionClonerMap.put(className, (SolutionCloner)runtimeValue.getValue()));
                solverConfig.setGizmoMemberAccessorMap(memberAccessorMap);
                solverConfig.setGizmoSolutionClonerMap(solutionClonerMap);
                StringWriter effectiveSolverConfigWriter = new StringWriter();
                SolverConfigIO solverConfigIO = new SolverConfigIO();
                solverConfigIO.write(solverConfig, (Writer)effectiveSolverConfigWriter);
                uiSolverConfig.setSolverConfigFile((String)solverName, effectiveSolverConfigWriter.toString());
                uiSolverConfig.setFactory((String)solverName, (SolverFactory<?>)SolverFactory.create((SolverConfig)solverConfig));
            });
            return uiSolverConfig;
        };
    }

    private void updateSolverConfigWithRuntimeProperties(String solverName, SolverConfig solverConfig, TimefoldRuntimeConfig timefoldRunTimeConfig) {
        TerminationConfig terminationConfig = solverConfig.getTerminationConfig();
        if (terminationConfig == null) {
            terminationConfig = new TerminationConfig();
            solverConfig.setTerminationConfig(terminationConfig);
        }
        timefoldRunTimeConfig.getSolverRuntimeConfig(solverName).flatMap(config -> config.termination().spentLimit()).ifPresent(arg_0 -> ((TerminationConfig)terminationConfig).setSpentLimit(arg_0));
        timefoldRunTimeConfig.getSolverRuntimeConfig(solverName).flatMap(config -> config.termination().unimprovedSpentLimit()).ifPresent(arg_0 -> ((TerminationConfig)terminationConfig).setUnimprovedSpentLimit(arg_0));
        timefoldRunTimeConfig.getSolverRuntimeConfig(solverName).flatMap(config -> config.termination().bestScoreLimit()).ifPresent(arg_0 -> ((TerminationConfig)terminationConfig).setBestScoreLimit(arg_0));
        timefoldRunTimeConfig.getSolverRuntimeConfig(solverName).flatMap(SolverRuntimeConfig::moveThreadCount).ifPresent(arg_0 -> ((SolverConfig)solverConfig).setMoveThreadCount(arg_0));
    }
}

