/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.test.impl.score.stream;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.api.score.constraint.ConstraintRef;
import ai.timefold.solver.core.api.score.stream.Constraint;
import ai.timefold.solver.core.api.score.stream.ConstraintFactory;
import ai.timefold.solver.core.api.score.stream.ConstraintProvider;
import ai.timefold.solver.core.config.solver.EnvironmentMode;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.core.impl.score.director.stream.BavetConstraintStreamScoreDirectorFactory;
import ai.timefold.solver.core.impl.score.stream.bavet.BavetConstraintFactory;
import ai.timefold.solver.core.impl.score.stream.common.AbstractConstraintStreamScoreDirectorFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;

final class ScoreDirectorFactoryCache<ConstraintProvider_ extends ConstraintProvider, Solution_, Score_ extends Score<Score_>> {
    private final Map<ConstraintRef, AbstractConstraintStreamScoreDirectorFactory<Solution_, Score_>> scoreDirectorFactoryMap = new HashMap<ConstraintRef, AbstractConstraintStreamScoreDirectorFactory<Solution_, Score_>>();
    private final SolutionDescriptor<Solution_> solutionDescriptor;

    public ScoreDirectorFactoryCache(SolutionDescriptor<Solution_> solutionDescriptor) {
        this.solutionDescriptor = Objects.requireNonNull(solutionDescriptor);
    }

    public AbstractConstraintStreamScoreDirectorFactory<Solution_, Score_> getScoreDirectorFactory(BiFunction<ConstraintProvider_, ConstraintFactory, Constraint> constraintFunction, ConstraintProvider_ constraintProvider, EnvironmentMode environmentMode) {
        BavetConstraintFactory fullConstraintFactory = new BavetConstraintFactory(this.solutionDescriptor, environmentMode);
        List constraints = fullConstraintFactory.buildConstraints(constraintProvider);
        Constraint expectedConstraint = constraintFunction.apply(constraintProvider, (ConstraintFactory)fullConstraintFactory);
        Constraint result = constraints.stream().filter(c -> Objects.equals(c.getConstraintRef(), expectedConstraint.getConstraintRef())).findFirst().orElseThrow(() -> new IllegalStateException("Impossible state: Constraint provider (" + constraintProvider + ") has no constraint (" + expectedConstraint + ")."));
        return this.getScoreDirectorFactory(result.getConstraintRef(), constraintFactory -> new Constraint[]{result}, environmentMode);
    }

    public AbstractConstraintStreamScoreDirectorFactory<Solution_, Score_> getScoreDirectorFactory(ConstraintRef constraintRef, ConstraintProvider constraintProvider, EnvironmentMode environmentMode) {
        return this.scoreDirectorFactoryMap.computeIfAbsent(constraintRef, k -> new BavetConstraintStreamScoreDirectorFactory(this.solutionDescriptor, constraintProvider, environmentMode));
    }
}

