/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.intent;

import android.app.Instrumentation;
import android.content.Intent;
import android.view.View;
import androidx.test.annotation.Beta;
import androidx.test.espresso.Espresso;
import androidx.test.espresso.NoMatchingViewException;
import androidx.test.espresso.ViewAssertion;
import androidx.test.espresso.intent.Checks;
import androidx.test.espresso.intent.OngoingStubbing;
import androidx.test.espresso.intent.ResettingStubber;
import androidx.test.espresso.intent.ResettingStubberImpl;
import androidx.test.espresso.intent.VerifiableIntent;
import androidx.test.espresso.intent.VerifiableIntentImpl;
import androidx.test.espresso.intent.VerificationMode;
import androidx.test.espresso.intent.VerificationModes;
import androidx.test.espresso.intent.matcher.IntentMatchers;
import androidx.test.espresso.matcher.ViewMatchers;
import androidx.test.internal.runner.tracker.UsageTrackerRegistry;
import androidx.test.platform.app.InstrumentationRegistry;
import androidx.test.runner.intent.IntentCallback;
import androidx.test.runner.intent.IntentMonitor;
import androidx.test.runner.intent.IntentMonitorRegistry;
import androidx.test.runner.intent.IntentStubber;
import androidx.test.runner.intent.IntentStubberRegistry;
import androidx.test.runner.lifecycle.ActivityLifecycleMonitor;
import androidx.test.runner.lifecycle.ActivityLifecycleMonitorRegistry;
import androidx.test.runner.lifecycle.Stage;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import org.hamcrest.Matcher;

public final class Intents {
    private static Intents defaultInstance;
    private static final List<VerifiableIntent> recordedIntents;
    private static boolean isInitialized;
    private final ResettingStubber resettingStubber;
    private final IntentCallback intentCallback = new IntentCallback(){

        public void onIntentSent(Intent intent) {
            recordedIntents.add(new VerifiableIntentImpl(((ResettingStubberImpl)Intents.this.resettingStubber).resolveIntent(intent)));
        }
    };
    private IntentMonitor intentMonitor;
    private static Instrumentation instrumentation;

    Intents(ResettingStubber resettingStubber) {
        this.resettingStubber = Checks.checkNotNull(resettingStubber);
    }

    public static void init() {
        if (!IntentStubberRegistry.isLoaded()) {
            ResettingStubberImpl resettingStubber = new ResettingStubberImpl();
            IntentStubberRegistry.load((IntentStubber)resettingStubber);
            defaultInstance = new Intents(resettingStubber);
        }
        defaultInstance.internalInit();
    }

    public static void release() {
        if (defaultInstance != null) {
            defaultInstance.internalRelease();
        }
    }

    public static OngoingStubbing intending(Matcher<Intent> matcher) {
        return Checks.checkNotNull(defaultInstance, "Intents not initialized. Did you forget to call init()?").internalIntending(matcher);
    }

    public static void intended(Matcher<Intent> matcher) {
        Intents.intended(matcher, Intents.times(1));
    }

    public static void intended(final Matcher<Intent> matcher, final VerificationMode verificationMode) {
        Checks.checkNotNull(defaultInstance, "Intents not initialized. Did you forget to call init()?");
        Instrumentation instrumentation = InstrumentationRegistry.getInstrumentation();
        instrumentation.waitForIdleSync();
        if (Intents.resumedActivitiesExist(instrumentation)) {
            Espresso.onView((Matcher)ViewMatchers.isRoot()).check(new ViewAssertion(){

                public void check(View view, NoMatchingViewException noViewFoundException) {
                    defaultInstance.internalIntended((Matcher<Intent>)matcher, verificationMode, recordedIntents);
                }
            });
        } else {
            PropogatingRunnable intendedRunnable = new PropogatingRunnable(new Runnable(){

                @Override
                public void run() {
                    defaultInstance.internalIntended((Matcher<Intent>)matcher, verificationMode, recordedIntents);
                }
            });
            instrumentation.runOnMainSync((Runnable)intendedRunnable);
            instrumentation.waitForIdleSync();
            intendedRunnable.checkException();
        }
    }

    @Beta
    public static List<Intent> getIntents() {
        FutureTask<List<Intent>> getIntents = new FutureTask<List<Intent>>(new Callable<List<Intent>>(){

            @Override
            public List<Intent> call() throws Exception {
                ArrayList<Intent> intents = new ArrayList<Intent>();
                for (VerifiableIntent verifiableIntent : recordedIntents) {
                    intents.add(verifiableIntent.getIntent());
                }
                return intents;
            }
        });
        instrumentation.runOnMainSync(getIntents);
        try {
            return getIntents.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public static VerificationMode times(int times) {
        if (times < 0) {
            throw new IllegalArgumentException("times expects a nonnegative integer");
        }
        return VerificationModes.times(times);
    }

    public static void assertNoUnverifiedIntents() {
        Intents.intended(IntentMatchers.anyIntent(), VerificationModes.noUnverifiedIntents());
    }

    private static boolean resumedActivitiesExist(Instrumentation instrumentation) {
        FutureTask<Boolean> checkResumed = new FutureTask<Boolean>(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                ActivityLifecycleMonitor monitor = ActivityLifecycleMonitorRegistry.getInstance();
                return !monitor.getActivitiesInStage(Stage.RESUMED).isEmpty();
            }
        });
        instrumentation.runOnMainSync(checkResumed);
        try {
            return checkResumed.get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    void internalInit() {
        Checks.checkState(!isInitialized, "#init was called twice in a row. Make sure to call #release after every #init");
        instrumentation = InstrumentationRegistry.getInstrumentation();
        this.intentMonitor = IntentMonitorRegistry.getInstance();
        this.intentMonitor.addIntentCallback(this.intentCallback);
        this.resettingStubber.initialize();
        isInitialized = true;
    }

    OngoingStubbing internalIntending(Matcher<Intent> matcher) {
        return new OngoingStubbing(matcher, this.resettingStubber, instrumentation);
    }

    void internalRelease() {
        Checks.checkState(isInitialized, "init() must be called prior to using this method.");
        this.intentMonitor.removeIntentCallback(this.intentCallback);
        IntentStubberRegistry.reset();
        instrumentation.runOnMainSync(new Runnable(){

            @Override
            public void run() {
                recordedIntents.clear();
                Intents.this.resettingStubber.reset();
            }
        });
        isInitialized = false;
    }

    void internalIntended(Matcher<Intent> matcher, VerificationMode verificationMode, List<VerifiableIntent> intents) {
        Checks.checkState(isInitialized, "init() must be called prior to using this method.");
        verificationMode.verify(matcher, intents);
    }

    static {
        UsageTrackerRegistry.getInstance().trackUsage("Intento", "3.4.0");
        recordedIntents = new ArrayList<VerifiableIntent>();
        isInitialized = false;
    }

    private static final class PropogatingRunnable
    implements Runnable {
        private final Runnable delegate;
        private AssertionError exception;

        public PropogatingRunnable(Runnable theRunnable) {
            this.delegate = theRunnable;
        }

        @Override
        public final void run() {
            try {
                this.delegate.run();
            }
            catch (AssertionError e) {
                this.exception = e;
            }
        }

        public void checkException() {
            if (this.exception != null) {
                throw this.exception;
            }
        }
    }
}

