/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.intent.matcher;

import android.os.Bundle;
import androidx.test.espresso.intent.Checks;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;

public final class BundleMatchers {
    private BundleMatchers() {
    }

    public static Matcher<Bundle> isEmpty() {
        return new EmptyBundleMatcher();
    }

    public static Matcher<Bundle> isEmptyOrNull() {
        return Matchers.anyOf((Matcher[])new Matcher[]{Matchers.nullValue(), BundleMatchers.isEmpty()});
    }

    public static <T> Matcher<Bundle> hasEntry(String key, T value) {
        return BundleMatchers.hasEntry((Matcher<String>)Matchers.is((Object)key), Matchers.is(value));
    }

    public static Matcher<Bundle> hasEntry(String key, Matcher<?> valueMatcher) {
        return BundleMatchers.hasEntry((Matcher<String>)Matchers.is((Object)key), valueMatcher);
    }

    public static Matcher<Bundle> hasEntry(Matcher<String> keyMatcher, Matcher<?> valueMatcher) {
        return new BundleMatcher(keyMatcher, valueMatcher);
    }

    public static Matcher<Bundle> hasKey(String key) {
        return BundleMatchers.hasKey((Matcher<String>)Matchers.is((Object)key));
    }

    public static Matcher<Bundle> hasKey(Matcher<String> keyMatcher) {
        return new BundleMatcher(keyMatcher, Matchers.anything());
    }

    public static <T> Matcher<Bundle> hasValue(T value) {
        return BundleMatchers.hasValue(Matchers.is(value));
    }

    public static Matcher<Bundle> hasValue(Matcher<?> valueMatcher) {
        return new BundleMatcher((Matcher<String>)Matchers.any(String.class), valueMatcher);
    }

    private static final class EmptyBundleMatcher
    extends TypeSafeMatcher<Bundle> {
        private EmptyBundleMatcher() {
        }

        protected boolean matchesSafely(Bundle bundle) {
            return bundle.isEmpty();
        }

        public void describeTo(Description description) {
            description.appendText("is empty bundle");
        }
    }

    private static class BundleMatcher
    extends TypeSafeMatcher<Bundle> {
        private final Matcher<String> keyMatcher;
        private final Matcher<?> valueMatcher;

        BundleMatcher(Matcher<String> keyMatcher, Matcher<?> valueMatcher) {
            super(Bundle.class);
            this.keyMatcher = Checks.checkNotNull(keyMatcher);
            this.valueMatcher = Checks.checkNotNull(valueMatcher);
        }

        public boolean matchesSafely(Bundle bundle) {
            for (String key : bundle.keySet()) {
                if (!this.keyMatcher.matches((Object)key) || !this.valueMatcher.matches(bundle.get(key))) continue;
                return true;
            }
            return false;
        }

        public void describeTo(Description description) {
            description.appendText("has bundle with: key: ");
            description.appendDescriptionOf(this.keyMatcher);
            description.appendText(" value: ");
            description.appendDescriptionOf(this.valueMatcher);
        }
    }
}

