/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.model;

import au.com.dius.pact.model.Interaction;
import au.com.dius.pact.model.InvalidPactException;
import au.com.dius.pact.model.MergeResult;
import au.com.dius.pact.model.Pact;
import au.com.dius.pact.model.PactMerge;
import au.com.dius.pact.model.PactSpecVersion;
import au.com.dius.pact.model.PactWriteMode;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.nio.channels.FileLock;
import java.nio.charset.Charset;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J2\u0010\f\u001a\u00020\r\"\b\b\u0000\u0010\u000e*\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u0015H\u0007J0\u0010\f\u001a\u00020\r\"\b\b\u0000\u0010\u000e*\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0007R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lau/com/dius/pact/model/PactWriter;", "Lmu/KLogging;", "()V", "gson", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "pactWriteMode", "Lau/com/dius/pact/model/PactWriteMode;", "readFileUtf8", "", "file", "Ljava/io/RandomAccessFile;", "writePact", "", "I", "Lau/com/dius/pact/model/Interaction;", "pact", "Lau/com/dius/pact/model/Pact;", "writer", "Ljava/io/PrintWriter;", "pactSpecVersion", "Lau/com/dius/pact/model/PactSpecVersion;", "pactFile", "Ljava/io/File;", "pact-jvm-model"})
public final class PactWriter
extends KLogging {
    private static final Gson gson;
    public static final PactWriter INSTANCE;

    @JvmStatic
    @JvmOverloads
    public static final <I extends Interaction> void writePact(@NotNull Pact<I> pact, @NotNull PrintWriter writer, @NotNull PactSpecVersion pactSpecVersion) {
        Intrinsics.checkParameterIsNotNull(pact, (String)"pact");
        Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
        Intrinsics.checkParameterIsNotNull((Object)((Object)pactSpecVersion), (String)"pactSpecVersion");
        pact.sortInteractions();
        Map<String, ?> jsonData = pact.toMap(pactSpecVersion);
        gson.toJson(jsonData, (Appendable)writer);
    }

    @JvmStatic
    @JvmOverloads
    public static /* synthetic */ void writePact$default(Pact pact, PrintWriter printWriter, PactSpecVersion pactSpecVersion, int n, Object object) {
        if ((n & 4) != 0) {
            pactSpecVersion = PactSpecVersion.V3;
        }
        PactWriter.writePact(pact, printWriter, pactSpecVersion);
    }

    @JvmStatic
    @JvmOverloads
    public static final <I extends Interaction> void writePact(@NotNull Pact<I> pact, @NotNull PrintWriter writer) {
        PactWriter.writePact$default(pact, writer, null, 4, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    public static final synchronized <I extends Interaction> void writePact(@NotNull File pactFile, @NotNull Pact<I> pact, @NotNull PactSpecVersion pactSpecVersion) {
        Intrinsics.checkParameterIsNotNull((Object)pactFile, (String)"pactFile");
        Intrinsics.checkParameterIsNotNull(pact, (String)"pact");
        Intrinsics.checkParameterIsNotNull((Object)((Object)pactSpecVersion), (String)"pactSpecVersion");
        if (INSTANCE.pactWriteMode() == PactWriteMode.MERGE && pactFile.exists() && pactFile.length() > 0L) {
            RandomAccessFile raf = new RandomAccessFile(pactFile, "rw");
            FileLock lock = raf.getChannel().lock();
            try {
                Class<?> pactReaderClass = Class.forName("au.com.dius.pact.model.PactReader");
                Method loadPact = pactReaderClass.getDeclaredMethod("loadPact", Class.forName("java.lang.Object"));
                Object object = loadPact.invoke(null, INSTANCE.readFileUtf8(raf));
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type au.com.dius.pact.model.Pact<I>");
                }
                Pact existingPact = (Pact)object;
                MergeResult<I> result = PactMerge.merge(existingPact, pact);
                if (!result.getOk()) {
                    throw (Throwable)new InvalidPactException(result.getMessage());
                }
                raf.seek(0L);
                StringWriter swriter = new StringWriter();
                PrintWriter writer = new PrintWriter(swriter);
                PactWriter.writePact(pact, writer, pactSpecVersion);
                String string = swriter.toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"swriter.toString()");
                String string2 = string;
                Charset charset2 = Charsets.UTF_8;
                boolean bl = false;
                String string3 = string2;
                if (string3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                byte[] byArray = string3.getBytes(charset2);
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                byte[] bytes = byArray;
                raf.setLength(bytes.length);
                raf.write(bytes);
            }
            finally {
                lock.release();
                raf.close();
            }
        }
        pactFile.getParentFile().mkdirs();
        Object object = pactFile;
        Charset charset3 = Charsets.UTF_8;
        boolean bl = false;
        File loadPact = object;
        int existingPact = 8192;
        boolean bl2 = false;
        Object object2 = loadPact;
        boolean bl3 = false;
        Object object3 = object2;
        boolean bl4 = false;
        object3 = new FileOutputStream((File)object3);
        bl4 = false;
        object2 = new OutputStreamWriter((OutputStream)object3, charset3);
        bl3 = false;
        BufferedWriter bufferedWriter = object2 instanceof BufferedWriter ? (BufferedWriter)object2 : new BufferedWriter((Writer)object2, existingPact);
        Writer writer = bufferedWriter;
        object = new PrintWriter(writer);
        boolean bl5 = false;
        Throwable throwable = null;
        try {
            PrintWriter it = (PrintWriter)object;
            boolean bl6 = false;
            PactWriter.writePact(pact, it, pactSpecVersion);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final PactWriteMode pactWriteMode() {
        PactWriteMode pactWriteMode;
        String string = System.getProperty("pact.writer.overwrite");
        if (string != null) {
            String string2 = string;
            switch (string2.hashCode()) {
                case 3569038: {
                    if (!string2.equals("true")) break;
                    pactWriteMode = PactWriteMode.OVERWRITE;
                    return pactWriteMode;
                }
            }
        }
        pactWriteMode = PactWriteMode.MERGE;
        return pactWriteMode;
    }

    private final String readFileUtf8(RandomAccessFile file) {
        byte[] buffer = new byte[128];
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        int count = file.read(buffer);
        while (count > 0) {
            data.write(buffer);
            count = file.read(buffer);
        }
        byte[] byArray = data.toByteArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"data.toByteArray()");
        byte[] byArray2 = byArray;
        Charset charset2 = Charset.forName("UTF-8");
        Intrinsics.checkExpressionValueIsNotNull((Object)charset2, (String)"Charset.forName(\"UTF-8\")");
        Charset charset3 = charset2;
        boolean bl = false;
        return new String(byArray2, charset3);
    }

    private PactWriter() {
    }

    static {
        PactWriter pactWriter;
        INSTANCE = pactWriter = new PactWriter();
        gson = new GsonBuilder().setPrettyPrinting().serializeNulls().create();
    }
}

