/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.consumer.dsl;

import au.com.dius.pact.consumer.dsl.PactDslRequestWithoutPath;
import au.com.dius.pact.core.model.OptionalBody;
import au.com.dius.pact.core.model.generators.Category;
import au.com.dius.pact.core.model.generators.DateGenerator;
import au.com.dius.pact.core.model.generators.DateTimeGenerator;
import au.com.dius.pact.core.model.generators.Generator;
import au.com.dius.pact.core.model.generators.Generators;
import au.com.dius.pact.core.model.generators.TimeGenerator;
import au.com.dius.pact.core.model.matchingrules.DateMatcher;
import au.com.dius.pact.core.model.matchingrules.MatchingRule;
import au.com.dius.pact.core.model.matchingrules.MatchingRules;
import au.com.dius.pact.core.model.matchingrules.MatchingRulesImpl;
import au.com.dius.pact.core.model.matchingrules.RegexMatcher;
import au.com.dius.pact.core.model.matchingrules.TimeMatcher;
import au.com.dius.pact.core.model.matchingrules.TimestampMatcher;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;

public abstract class PactDslRequestBase {
    protected static final String CONTENT_TYPE = "Content-Type";
    private static final long DATE_2000 = 949323600000L;
    protected final PactDslRequestWithoutPath defaultRequestValues;
    protected String requestMethod = "GET";
    protected Map<String, List<String>> requestHeaders = new HashMap<String, List<String>>();
    protected Map<String, List<String>> query = new HashMap<String, List<String>>();
    protected OptionalBody requestBody = OptionalBody.missing();
    protected MatchingRules requestMatchers = new MatchingRulesImpl();
    protected Generators requestGenerators = new Generators();

    public PactDslRequestBase(PactDslRequestWithoutPath defaultRequestValues) {
        this.defaultRequestValues = defaultRequestValues;
    }

    protected void setupDefaultValues() {
        if (this.defaultRequestValues != null) {
            if (StringUtils.isNotEmpty((CharSequence)this.defaultRequestValues.requestMethod)) {
                this.requestMethod = this.defaultRequestValues.requestMethod;
            }
            this.requestHeaders.putAll(this.defaultRequestValues.requestHeaders);
            this.query.putAll(this.defaultRequestValues.query);
            this.requestBody = this.defaultRequestValues.requestBody;
            this.requestMatchers = ((MatchingRulesImpl)this.defaultRequestValues.requestMatchers).copy();
            this.requestGenerators = new Generators(this.defaultRequestValues.requestGenerators.getCategories());
        }
    }

    protected void setupFileUpload(String partName, String fileName, String fileContentType, byte[] data) throws IOException {
        ContentType contentType = ContentType.DEFAULT_TEXT;
        if (!fileContentType.isEmpty()) {
            contentType = ContentType.create((String)fileContentType);
        }
        MultipartEntityBuilder multipart = MultipartEntityBuilder.create().setMode(HttpMultipartMode.BROWSER_COMPATIBLE).addBinaryBody(partName, data, contentType, fileName);
        this.setupMultipart(multipart);
    }

    protected void setupMultipart(MultipartEntityBuilder multipartBuilder) throws IOException {
        HttpEntity multipart = multipartBuilder.build();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        multipart.writeTo((OutputStream)os);
        this.requestBody = OptionalBody.body((byte[])os.toByteArray(), (au.com.dius.pact.core.model.ContentType)new au.com.dius.pact.core.model.ContentType(multipart.getContentType().getValue()));
        this.requestMatchers.addCategory("header").addRule(CONTENT_TYPE, (MatchingRule)new RegexMatcher("multipart/form-data;(\\s*charset=[^;]*;)?\\s*boundary=.*", multipart.getContentType().getValue()));
        this.requestHeaders.put(CONTENT_TYPE, Collections.singletonList(multipart.getContentType().getValue()));
    }

    protected PactDslRequestBase queryMatchingDateBase(String field, String pattern, String example) {
        this.requestMatchers.addCategory("query").addRule(field, (MatchingRule)new DateMatcher(pattern));
        if (StringUtils.isNotEmpty((CharSequence)example)) {
            this.query.put(field, Collections.singletonList(example));
        } else {
            this.requestGenerators.addGenerator(Category.BODY, field, (Generator)new DateGenerator(pattern, null));
            FastDateFormat instance = FastDateFormat.getInstance((String)pattern);
            this.query.put(field, Collections.singletonList(instance.format(new Date(949323600000L))));
        }
        return this;
    }

    protected PactDslRequestBase queryMatchingTimeBase(String field, String pattern, String example) {
        this.requestMatchers.addCategory("query").addRule(field, (MatchingRule)new TimeMatcher(pattern));
        if (StringUtils.isNotEmpty((CharSequence)example)) {
            this.query.put(field, Collections.singletonList(example));
        } else {
            this.requestGenerators.addGenerator(Category.BODY, field, (Generator)new TimeGenerator(pattern, null));
            FastDateFormat instance = FastDateFormat.getInstance((String)pattern);
            this.query.put(field, Collections.singletonList(instance.format(new Date(949323600000L))));
        }
        return this;
    }

    protected PactDslRequestBase queryMatchingDatetimeBase(String field, String pattern, String example) {
        this.requestMatchers.addCategory("query").addRule(field, (MatchingRule)new TimestampMatcher(pattern));
        if (StringUtils.isNotEmpty((CharSequence)example)) {
            this.query.put(field, Collections.singletonList(example));
        } else {
            this.requestGenerators.addGenerator(Category.BODY, field, (Generator)new DateTimeGenerator(pattern, null));
            FastDateFormat instance = FastDateFormat.getInstance((String)pattern);
            this.query.put(field, Collections.singletonList(instance.format(new Date(949323600000L))));
        }
        return this;
    }

    protected boolean isContentTypeHeaderNotSet() {
        return this.requestHeaders.keySet().stream().noneMatch(key -> key.equalsIgnoreCase(CONTENT_TYPE));
    }

    protected String getContentTypeHeader() {
        return this.requestHeaders.entrySet().stream().filter(entry -> ((String)entry.getKey()).equalsIgnoreCase(CONTENT_TYPE)).findFirst().map(entry -> (String)((List)entry.getValue()).get(0)).orElse("");
    }
}

