/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.consumer.dsl;

import au.com.dius.pact.consumer.InvalidMatcherException;
import au.com.dius.pact.consumer.dsl.DslPart;
import au.com.dius.pact.consumer.dsl.PactDslJsonArray;
import au.com.dius.pact.consumer.dsl.PactDslJsonBody;
import au.com.dius.pact.core.model.generators.Category;
import au.com.dius.pact.core.model.generators.DateGenerator;
import au.com.dius.pact.core.model.generators.DateTimeGenerator;
import au.com.dius.pact.core.model.generators.Generator;
import au.com.dius.pact.core.model.generators.ProviderStateGenerator;
import au.com.dius.pact.core.model.generators.RandomDecimalGenerator;
import au.com.dius.pact.core.model.generators.RandomHexadecimalGenerator;
import au.com.dius.pact.core.model.generators.RandomIntGenerator;
import au.com.dius.pact.core.model.generators.RandomStringGenerator;
import au.com.dius.pact.core.model.generators.TimeGenerator;
import au.com.dius.pact.core.model.generators.UuidGenerator;
import au.com.dius.pact.core.model.matchingrules.MatchingRule;
import au.com.dius.pact.core.model.matchingrules.MatchingRuleGroup;
import au.com.dius.pact.core.model.matchingrules.NumberTypeMatcher;
import au.com.dius.pact.core.model.matchingrules.RuleLogic;
import au.com.dius.pact.core.model.matchingrules.TypeMatcher;
import au.com.dius.pact.core.support.expressions.DataType;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.UUID;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.json.JSONObject;

public class PactDslRootValue
extends DslPart {
    private static final String USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS = "Use PactDslJsonArray for arrays";
    private static final String USE_PACT_DSL_JSON_BODY_FOR_OBJECTS = "Use PactDslJsonBody for objects";
    private static final String EXAMPLE = "Example \"";
    private Object value;
    private boolean encodeJson = false;

    public PactDslRootValue() {
        super("", "");
    }

    @Override
    protected void putObject(DslPart object) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void putArray(DslPart object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getBody() {
        return this.value;
    }

    @Override
    public PactDslJsonArray array(String name) {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    @Override
    public PactDslJsonArray array() {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    @Override
    public DslPart closeArray() {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    @Override
    public PactDslJsonBody eachLike(String name) {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    @Override
    public PactDslJsonBody eachLike(String name, DslPart object) {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    @Override
    public PactDslJsonBody eachLike(int numberExamples) {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    @Override
    public PactDslJsonBody eachLike(String name, int numberExamples) {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    @Override
    public PactDslJsonBody eachLike() {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    @Override
    public PactDslJsonArray eachLike(DslPart object) {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    @Override
    public PactDslJsonBody minArrayLike(String name, Integer size) {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    @Override
    public PactDslJsonBody minArrayLike(Integer size) {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    @Override
    public PactDslJsonBody minArrayLike(String name, Integer size, DslPart object) {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    @Override
    public PactDslJsonArray minArrayLike(Integer size, DslPart object) {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    @Override
    public PactDslJsonBody minArrayLike(String name, Integer size, int numberExamples) {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    @Override
    public PactDslJsonBody minArrayLike(Integer size, int numberExamples) {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    @Override
    public PactDslJsonBody maxArrayLike(String name, Integer size) {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    @Override
    public PactDslJsonBody maxArrayLike(Integer size) {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    @Override
    public PactDslJsonBody maxArrayLike(String name, Integer size, DslPart object) {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    @Override
    public PactDslJsonArray maxArrayLike(Integer size, DslPart object) {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    @Override
    public PactDslJsonBody maxArrayLike(String name, Integer size, int numberExamples) {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    @Override
    public PactDslJsonBody maxArrayLike(Integer size, int numberExamples) {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    @Override
    public PactDslJsonBody minMaxArrayLike(String name, Integer minSize, Integer maxSize) {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    @Override
    public PactDslJsonBody minMaxArrayLike(String name, Integer minSize, Integer maxSize, DslPart object) {
        return null;
    }

    @Override
    public PactDslJsonBody minMaxArrayLike(Integer minSize, Integer maxSize) {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    @Override
    public PactDslJsonArray minMaxArrayLike(Integer minSize, Integer maxSize, DslPart object) {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    @Override
    public PactDslJsonBody minMaxArrayLike(String name, Integer minSize, Integer maxSize, int numberExamples) {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    @Override
    public PactDslJsonBody minMaxArrayLike(Integer minSize, Integer maxSize, int numberExamples) {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    @Override
    public PactDslJsonBody object(String name) {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_BODY_FOR_OBJECTS);
    }

    @Override
    public PactDslJsonBody object() {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_BODY_FOR_OBJECTS);
    }

    @Override
    public DslPart closeObject() {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_BODY_FOR_OBJECTS);
    }

    @Override
    public DslPart close() {
        this.getMatchers().applyMatcherRootPrefix("$");
        this.getGenerators().applyRootPrefix("$");
        return this;
    }

    public static PactDslRootValue stringType() {
        PactDslRootValue value = new PactDslRootValue();
        value.generators.addGenerator(Category.BODY, "", (Generator)new RandomStringGenerator(20));
        value.setValue("string");
        value.setMatcher((MatchingRule)TypeMatcher.INSTANCE);
        return value;
    }

    public static PactDslRootValue stringType(String example) {
        PactDslRootValue value = new PactDslRootValue();
        value.setValue(example);
        value.setMatcher((MatchingRule)TypeMatcher.INSTANCE);
        return value;
    }

    public static PactDslRootValue numberType() {
        PactDslRootValue value = new PactDslRootValue();
        value.generators.addGenerator(Category.BODY, "", (Generator)new RandomIntGenerator(0, Integer.MAX_VALUE));
        value.setValue(100);
        value.setMatcher((MatchingRule)TypeMatcher.INSTANCE);
        return value;
    }

    public static PactDslRootValue numberType(Number number) {
        PactDslRootValue value = new PactDslRootValue();
        value.setValue(number);
        value.setMatcher((MatchingRule)TypeMatcher.INSTANCE);
        return value;
    }

    public static PactDslRootValue integerType() {
        PactDslRootValue value = new PactDslRootValue();
        value.generators.addGenerator(Category.BODY, "", (Generator)new RandomIntGenerator(0, Integer.MAX_VALUE));
        value.setValue(100);
        value.setMatcher((MatchingRule)new NumberTypeMatcher(NumberTypeMatcher.NumberType.INTEGER));
        return value;
    }

    public static PactDslRootValue integerType(Long number) {
        PactDslRootValue value = new PactDslRootValue();
        value.setValue(number);
        value.setMatcher((MatchingRule)new NumberTypeMatcher(NumberTypeMatcher.NumberType.INTEGER));
        return value;
    }

    public static PactDslRootValue integerType(Integer number) {
        PactDslRootValue value = new PactDslRootValue();
        value.setValue(number);
        value.setMatcher((MatchingRule)new NumberTypeMatcher(NumberTypeMatcher.NumberType.INTEGER));
        return value;
    }

    public static PactDslRootValue decimalType() {
        PactDslRootValue value = new PactDslRootValue();
        value.generators.addGenerator(Category.BODY, "", (Generator)new RandomDecimalGenerator(10));
        value.setValue(100);
        value.setMatcher((MatchingRule)new NumberTypeMatcher(NumberTypeMatcher.NumberType.DECIMAL));
        return value;
    }

    public static PactDslRootValue decimalType(BigDecimal number) {
        PactDslRootValue value = new PactDslRootValue();
        value.setValue(number);
        value.setMatcher((MatchingRule)new NumberTypeMatcher(NumberTypeMatcher.NumberType.DECIMAL));
        return value;
    }

    public static PactDslRootValue decimalType(Double number) {
        PactDslRootValue value = new PactDslRootValue();
        value.setValue(number);
        value.setMatcher((MatchingRule)new NumberTypeMatcher(NumberTypeMatcher.NumberType.DECIMAL));
        return value;
    }

    public static PactDslRootValue booleanType() {
        return PactDslRootValue.booleanType(true);
    }

    public static PactDslRootValue booleanType(Boolean example) {
        PactDslRootValue value = new PactDslRootValue();
        value.setValue(example);
        value.setMatcher((MatchingRule)TypeMatcher.INSTANCE);
        return value;
    }

    public static PactDslRootValue stringMatcher(String regex, String value) {
        if (!value.matches(regex)) {
            throw new InvalidMatcherException(EXAMPLE + value + "\" does not match regular expression \"" + regex + "\"");
        }
        PactDslRootValue rootValue = new PactDslRootValue();
        rootValue.setValue(value);
        rootValue.setMatcher((MatchingRule)rootValue.regexp(regex));
        return rootValue;
    }

    public static PactDslRootValue timestamp() {
        return PactDslRootValue.timestamp(DateFormatUtils.ISO_DATETIME_FORMAT.getPattern());
    }

    public static PactDslRootValue timestamp(String format) {
        PactDslRootValue value = new PactDslRootValue();
        value.generators.addGenerator(Category.BODY, "", (Generator)new DateTimeGenerator(format));
        FastDateFormat instance = FastDateFormat.getInstance((String)format);
        value.setValue(instance.format(new Date(949323600000L)));
        value.setMatcher((MatchingRule)value.matchTimestamp(format));
        return value;
    }

    public static PactDslRootValue timestamp(String format, Date example) {
        FastDateFormat instance = FastDateFormat.getInstance((String)format);
        PactDslRootValue value = new PactDslRootValue();
        value.setValue(instance.format(example));
        value.setMatcher((MatchingRule)value.matchTimestamp(format));
        return value;
    }

    public static PactDslRootValue date() {
        return PactDslRootValue.date(DateFormatUtils.ISO_DATE_FORMAT.getPattern());
    }

    public static PactDslRootValue date(String format) {
        FastDateFormat instance = FastDateFormat.getInstance((String)format);
        PactDslRootValue value = new PactDslRootValue();
        value.generators.addGenerator(Category.BODY, "", (Generator)new DateGenerator(format));
        value.setValue(instance.format(new Date(949323600000L)));
        value.setMatcher((MatchingRule)value.matchDate(format));
        return value;
    }

    public static PactDslRootValue date(String format, Date example) {
        FastDateFormat instance = FastDateFormat.getInstance((String)format);
        PactDslRootValue value = new PactDslRootValue();
        value.setValue(instance.format(example));
        value.setMatcher((MatchingRule)value.matchDate(format));
        return value;
    }

    public static PactDslRootValue time() {
        return PactDslRootValue.time(DateFormatUtils.ISO_TIME_FORMAT.getPattern());
    }

    public static PactDslRootValue time(String format) {
        FastDateFormat instance = FastDateFormat.getInstance((String)format);
        PactDslRootValue value = new PactDslRootValue();
        value.generators.addGenerator(Category.BODY, "", (Generator)new TimeGenerator(format));
        value.setValue(instance.format(new Date(949323600000L)));
        value.setMatcher((MatchingRule)value.matchTime(format));
        return value;
    }

    public static PactDslRootValue time(String format, Date example) {
        FastDateFormat instance = FastDateFormat.getInstance((String)format);
        PactDslRootValue value = new PactDslRootValue();
        value.setValue(instance.format(example));
        value.setMatcher((MatchingRule)value.matchTime(format));
        return value;
    }

    public static PactDslRootValue ipAddress() {
        PactDslRootValue value = new PactDslRootValue();
        value.setValue("127.0.0.1");
        value.setMatcher((MatchingRule)value.regexp("(\\d{1,3}\\.)+\\d{1,3}"));
        return value;
    }

    public static PactDslRootValue id() {
        return PactDslRootValue.numberType();
    }

    public static PactDslRootValue id(Long id) {
        return PactDslRootValue.numberType(id);
    }

    public static PactDslRootValue hexValue() {
        PactDslRootValue value = new PactDslRootValue();
        value.generators.addGenerator(Category.BODY, "", (Generator)new RandomHexadecimalGenerator(10));
        value.setValue("1234a");
        value.setMatcher((MatchingRule)value.regexp("[0-9a-fA-F]+"));
        return value;
    }

    public static PactDslRootValue hexValue(String hexValue) {
        if (!hexValue.matches("[0-9a-fA-F]+")) {
            throw new InvalidMatcherException(EXAMPLE + hexValue + "\" is not a hexadecimal value");
        }
        PactDslRootValue value = new PactDslRootValue();
        value.setValue(hexValue);
        value.setMatcher((MatchingRule)value.regexp("[0-9a-fA-F]+"));
        return value;
    }

    public static PactDslRootValue uuid() {
        PactDslRootValue value = new PactDslRootValue();
        value.generators.addGenerator(Category.BODY, "", (Generator)UuidGenerator.INSTANCE);
        value.setValue("e2490de5-5bd3-43d5-b7c4-526e33f71304");
        value.setMatcher((MatchingRule)value.regexp("[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}"));
        return value;
    }

    public static PactDslRootValue uuid(UUID uuid) {
        return PactDslRootValue.uuid(uuid.toString());
    }

    public static PactDslRootValue uuid(String uuid) {
        if (!uuid.matches("[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}")) {
            throw new InvalidMatcherException(EXAMPLE + uuid + "\" is not an UUID");
        }
        PactDslRootValue value = new PactDslRootValue();
        value.setValue(uuid);
        value.setMatcher((MatchingRule)value.regexp("[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}"));
        return value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void setMatcher(MatchingRule matcher) {
        this.matchers.addRule(matcher);
    }

    @Override
    public PactDslJsonArray eachArrayLike(String name) {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    @Override
    public PactDslJsonArray eachArrayLike(int numberExamples) {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    @Override
    public PactDslJsonArray eachArrayWithMaxLike(String name, Integer size) {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    @Override
    public PactDslJsonArray eachArrayWithMaxLike(Integer size) {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    @Override
    public PactDslJsonArray eachArrayWithMaxLike(String name, int numberExamples, Integer size) {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    @Override
    public PactDslJsonArray eachArrayWithMaxLike(int numberExamples, Integer size) {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    @Override
    public PactDslJsonArray eachArrayWithMinLike(String name, Integer size) {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    @Override
    public PactDslJsonArray eachArrayWithMinLike(Integer size) {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    @Override
    public PactDslJsonArray eachArrayWithMinLike(String name, int numberExamples, Integer size) {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    @Override
    public PactDslJsonArray eachArrayWithMinLike(int numberExamples, Integer size) {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    @Override
    public PactDslJsonArray eachArrayWithMinMaxLike(String name, Integer minSize, Integer maxSize) {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    @Override
    public PactDslJsonArray eachArrayWithMinMaxLike(Integer minSize, Integer maxSize) {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    @Override
    public PactDslJsonArray eachArrayWithMinMaxLike(String name, int numberExamples, Integer minSize, Integer maxSize) {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    @Override
    public PactDslJsonArray eachArrayWithMinMaxLike(int numberExamples, Integer minSize, Integer maxSize) {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    @Override
    public PactDslJsonArray eachArrayLike(String name, int numberExamples) {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    @Override
    public PactDslJsonArray eachArrayLike() {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    public static PactDslRootValue and(Object example, MatchingRule ... rules) {
        PactDslRootValue value = new PactDslRootValue();
        if (example != null) {
            value.setValue(example);
        } else {
            value.setValue(JSONObject.NULL);
        }
        value.matchers.setRules("", new MatchingRuleGroup(Arrays.asList(rules), RuleLogic.AND));
        return value;
    }

    public static PactDslRootValue or(Object example, MatchingRule ... rules) {
        PactDslRootValue value = new PactDslRootValue();
        if (example != null) {
            value.setValue(example);
        } else {
            value.setValue(JSONObject.NULL);
        }
        value.matchers.setRules("", new MatchingRuleGroup(Arrays.asList(rules), RuleLogic.OR));
        return value;
    }

    public static PactDslRootValue valueFromProviderState(String expression, Object example) {
        PactDslRootValue value = new PactDslRootValue();
        value.generators.addGenerator(Category.BODY, "", (Generator)new ProviderStateGenerator(expression, DataType.from((Object)example)));
        value.setValue(example);
        return value;
    }
}

