/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.consumer.dsl;

import au.com.dius.pact.consumer.dsl.LambdaDslJsonArray;
import au.com.dius.pact.consumer.dsl.PactDslJsonArray;
import au.com.dius.pact.consumer.dsl.PactDslJsonBody;
import au.com.dius.pact.consumer.dsl.PactDslJsonRootValue;
import au.com.dius.pact.core.model.matchingrules.MatchingRule;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.TimeZone;
import java.util.UUID;
import java.util.function.Consumer;

public class LambdaDslObject {
    private final PactDslJsonBody object;

    LambdaDslObject(PactDslJsonBody object) {
        this.object = object;
    }

    public PactDslJsonBody getPactDslObject() {
        return this.object;
    }

    public LambdaDslObject stringValue(String name, String value) {
        this.object.stringValue(name, value);
        return this;
    }

    public LambdaDslObject stringType(String name, String example) {
        this.object.stringType(name, example);
        return this;
    }

    public LambdaDslObject stringType(String name) {
        this.object.stringType(name);
        return this;
    }

    public LambdaDslObject stringType(String ... names) {
        this.object.stringTypes(names);
        return this;
    }

    public LambdaDslObject stringMatcher(String name, String regex) {
        this.object.stringMatcher(name, regex);
        return this;
    }

    public LambdaDslObject stringMatcher(String name, String regex, String example) {
        this.object.stringMatcher(name, regex, example);
        return this;
    }

    public LambdaDslObject numberValue(String name, Number value) {
        this.object.numberValue(name, value);
        return this;
    }

    public LambdaDslObject numberType(String name, Number example) {
        this.object.numberType(name, example);
        return this;
    }

    public LambdaDslObject numberType(String ... names) {
        this.object.numberTypes(names);
        return this;
    }

    public LambdaDslObject integerType(String name, Integer example) {
        this.object.integerType(name, example);
        return this;
    }

    public LambdaDslObject integerType(String ... names) {
        this.object.integerTypes(names);
        return this;
    }

    public LambdaDslObject decimalType(String name, BigDecimal example) {
        this.object.decimalType(name, example);
        return this;
    }

    public LambdaDslObject decimalType(String name, Double example) {
        this.object.decimalType(name, example);
        return this;
    }

    public LambdaDslObject decimalType(String ... names) {
        this.object.decimalTypes(names);
        return this;
    }

    public LambdaDslObject booleanValue(String name, Boolean value) {
        this.object.booleanValue(name, value);
        return this;
    }

    public LambdaDslObject booleanType(String name, Boolean example) {
        this.object.booleanType(name, example);
        return this;
    }

    public LambdaDslObject booleanType(String ... names) {
        this.object.booleanTypes(names);
        return this;
    }

    public LambdaDslObject id() {
        this.object.id();
        return this;
    }

    public LambdaDslObject id(String name) {
        this.object.id(name);
        return this;
    }

    public LambdaDslObject id(String name, Long example) {
        this.object.id(name, example);
        return this;
    }

    public LambdaDslObject uuid(String name) {
        this.object.uuid(name);
        return this;
    }

    public LambdaDslObject uuid(String name, UUID example) {
        this.object.uuid(name, example);
        return this;
    }

    public LambdaDslObject date() {
        this.object.date();
        return this;
    }

    public LambdaDslObject date(String name) {
        this.object.date(name);
        return this;
    }

    public LambdaDslObject date(String name, String format) {
        this.object.date(name, format);
        return this;
    }

    public LambdaDslObject date(String name, String format, Date example) {
        this.object.date(name, format, example);
        return this;
    }

    public LambdaDslObject date(String name, String format, Date example, TimeZone timeZone) {
        this.object.date(name, format, example, timeZone);
        return this;
    }

    public LambdaDslObject date(String name, String format, ZonedDateTime example) {
        this.object.date(name, format, Date.from(example.toInstant()), TimeZone.getTimeZone(example.getZone()));
        return this;
    }

    public LambdaDslObject time() {
        this.object.time();
        return this;
    }

    public LambdaDslObject time(String name) {
        this.object.time(name);
        return this;
    }

    public LambdaDslObject time(String name, String format) {
        this.object.time(name, format);
        return this;
    }

    public LambdaDslObject time(String name, String format, Date example) {
        this.object.time(name, format, example);
        return this;
    }

    public LambdaDslObject time(String name, String format, Date example, TimeZone timeZone) {
        this.object.time(name, format, example, timeZone);
        return this;
    }

    public LambdaDslObject time(String name, String format, ZonedDateTime example) {
        this.object.time(name, format, Date.from(example.toInstant()), TimeZone.getTimeZone(example.getZone()));
        return this;
    }

    @Deprecated
    public LambdaDslObject timestamp() {
        this.object.datetime("timestamp");
        return this;
    }

    @Deprecated
    public LambdaDslObject datetime(String name) {
        this.object.datetime(name);
        return this;
    }

    public LambdaDslObject datetime(String name, String format) {
        this.object.datetime(name, format);
        return this;
    }

    public LambdaDslObject datetime(String name, String format, Date example) {
        this.object.datetime(name, format, example);
        return this;
    }

    public LambdaDslObject datetime(String name, String format, Instant example) {
        this.object.datetime(name, format, example);
        return this;
    }

    public LambdaDslObject datetime(String name, String format, Date example, TimeZone timeZone) {
        this.object.datetime(name, format, example, timeZone);
        return this;
    }

    public LambdaDslObject datetime(String name, String format, ZonedDateTime example) {
        this.object.datetime(name, format, Date.from(example.toInstant()), TimeZone.getTimeZone(example.getZone()));
        return this;
    }

    public LambdaDslObject ipV4Address(String name) {
        this.object.ipAddress(name);
        return this;
    }

    public LambdaDslObject valueFromProviderState(String name, String expression, Object example) {
        this.object.valueFromProviderState(name, expression, example);
        return this;
    }

    public LambdaDslObject and(String name, Object value, MatchingRule ... rules) {
        this.object.and(name, value, rules);
        return this;
    }

    public LambdaDslObject or(String name, Object value, MatchingRule ... rules) {
        this.object.or(name, value, rules);
        return this;
    }

    public LambdaDslObject array(String name, Consumer<LambdaDslJsonArray> array) {
        PactDslJsonArray pactArray = this.object.array(name);
        LambdaDslJsonArray dslArray = new LambdaDslJsonArray(pactArray);
        array.accept(dslArray);
        pactArray.closeArray();
        return this;
    }

    public LambdaDslObject object(String name, Consumer<LambdaDslObject> nestedObject) {
        PactDslJsonBody pactObject = this.object.object(name);
        LambdaDslObject dslObject = new LambdaDslObject(pactObject);
        nestedObject.accept(dslObject);
        pactObject.closeObject();
        return this;
    }

    public LambdaDslObject eachLike(String name, Consumer<LambdaDslObject> nestedObject) {
        PactDslJsonBody arrayLike = this.object.eachLike(name);
        LambdaDslObject dslObject = new LambdaDslObject(arrayLike);
        nestedObject.accept(dslObject);
        arrayLike.closeArray();
        return this;
    }

    public LambdaDslObject eachLike(String name, int numberExamples, Consumer<LambdaDslObject> nestedObject) {
        PactDslJsonBody arrayLike = this.object.eachLike(name, numberExamples);
        LambdaDslObject dslObject = new LambdaDslObject(arrayLike);
        nestedObject.accept(dslObject);
        arrayLike.closeArray();
        return this;
    }

    public LambdaDslObject eachLike(String name, PactDslJsonRootValue value) {
        this.object.eachLike(name, value);
        return this;
    }

    public LambdaDslObject eachLike(String name, PactDslJsonRootValue value, int numberExamples) {
        this.object.eachLike(name, value, numberExamples);
        return this;
    }

    public LambdaDslObject minArrayLike(String name, Integer size, Consumer<LambdaDslObject> nestedObject) {
        PactDslJsonBody minArrayLike = this.object.minArrayLike(name, (int)size);
        LambdaDslObject dslObject = new LambdaDslObject(minArrayLike);
        nestedObject.accept(dslObject);
        minArrayLike.closeArray();
        return this;
    }

    public LambdaDslObject minArrayLike(String name, Integer size, int numberExamples, Consumer<LambdaDslObject> nestedObject) {
        PactDslJsonBody minArrayLike = this.object.minArrayLike(name, (int)size, numberExamples);
        LambdaDslObject dslObject = new LambdaDslObject(minArrayLike);
        nestedObject.accept(dslObject);
        minArrayLike.closeArray();
        return this;
    }

    public LambdaDslObject minArrayLike(String name, Integer size, PactDslJsonRootValue value, int numberExamples) {
        this.object.minArrayLike(name, size, value, numberExamples);
        return this;
    }

    public LambdaDslObject maxArrayLike(String name, Integer size, Consumer<LambdaDslObject> nestedObject) {
        PactDslJsonBody maxArrayLike = this.object.maxArrayLike(name, (int)size);
        LambdaDslObject dslObject = new LambdaDslObject(maxArrayLike);
        nestedObject.accept(dslObject);
        maxArrayLike.closeArray();
        return this;
    }

    public LambdaDslObject maxArrayLike(String name, Integer size, int numberExamples, Consumer<LambdaDslObject> nestedObject) {
        PactDslJsonBody maxArrayLike = this.object.maxArrayLike(name, (int)size, numberExamples);
        LambdaDslObject dslObject = new LambdaDslObject(maxArrayLike);
        nestedObject.accept(dslObject);
        maxArrayLike.closeArray();
        return this;
    }

    public LambdaDslObject maxArrayLike(String name, Integer size, PactDslJsonRootValue value, int numberExamples) {
        this.object.maxArrayLike(name, size, value, numberExamples);
        return this;
    }

    public LambdaDslObject minMaxArrayLike(String name, Integer minSize, Integer maxSize, Consumer<LambdaDslObject> nestedObject) {
        PactDslJsonBody maxArrayLike = this.object.minMaxArrayLike(name, (int)minSize, (int)maxSize);
        LambdaDslObject dslObject = new LambdaDslObject(maxArrayLike);
        nestedObject.accept(dslObject);
        maxArrayLike.closeArray();
        return this;
    }

    public LambdaDslObject minMaxArrayLike(String name, Integer minSize, Integer maxSize, int numberExamples, Consumer<LambdaDslObject> nestedObject) {
        PactDslJsonBody maxArrayLike = this.object.minMaxArrayLike(name, (int)minSize, (int)maxSize, numberExamples);
        LambdaDslObject dslObject = new LambdaDslObject(maxArrayLike);
        nestedObject.accept(dslObject);
        maxArrayLike.closeArray();
        return this;
    }

    public LambdaDslObject minMaxArrayLike(String name, Integer minSize, Integer maxSize, PactDslJsonRootValue value, int numberExamples) {
        this.object.minMaxArrayLike(name, minSize, maxSize, value, numberExamples);
        return this;
    }

    public LambdaDslObject nullValue(String fieldName) {
        this.object.nullValue(fieldName);
        return this;
    }

    public LambdaDslObject eachArrayLike(String name, Consumer<LambdaDslJsonArray> nestedArray) {
        PactDslJsonArray arrayLike = this.object.eachArrayLike(name);
        LambdaDslJsonArray dslArray = new LambdaDslJsonArray(arrayLike);
        nestedArray.accept(dslArray);
        arrayLike.closeArray().closeArray();
        return this;
    }

    public LambdaDslObject eachArrayLike(String name, int numberExamples, Consumer<LambdaDslJsonArray> nestedArray) {
        PactDslJsonArray arrayLike = this.object.eachArrayLike(name, numberExamples);
        LambdaDslJsonArray dslArray = new LambdaDslJsonArray(arrayLike);
        nestedArray.accept(dslArray);
        arrayLike.closeArray().closeArray();
        return this;
    }

    public LambdaDslObject eachArrayWithMaxLike(String name, Integer size, Consumer<LambdaDslJsonArray> nestedArray) {
        PactDslJsonArray arrayLike = this.object.eachArrayWithMaxLike(name, (int)size);
        LambdaDslJsonArray dslArray = new LambdaDslJsonArray(arrayLike);
        nestedArray.accept(dslArray);
        arrayLike.closeArray().closeArray();
        return this;
    }

    public LambdaDslObject eachArrayWithMaxLike(String name, int numberExamples, Integer size, Consumer<LambdaDslJsonArray> nestedArray) {
        PactDslJsonArray arrayLike = this.object.eachArrayWithMaxLike(name, numberExamples, size);
        LambdaDslJsonArray dslArray = new LambdaDslJsonArray(arrayLike);
        nestedArray.accept(dslArray);
        arrayLike.closeArray().closeArray();
        return this;
    }

    public LambdaDslObject eachArrayWithMinLike(String name, Integer size, Consumer<LambdaDslJsonArray> nestedArray) {
        PactDslJsonArray arrayLike = this.object.eachArrayWithMinLike(name, (int)size);
        LambdaDslJsonArray dslArray = new LambdaDslJsonArray(arrayLike);
        nestedArray.accept(dslArray);
        arrayLike.closeArray().closeArray();
        return this;
    }

    public LambdaDslObject eachArrayWithMinLike(String name, int numberExamples, Integer size, Consumer<LambdaDslJsonArray> nestedArray) {
        PactDslJsonArray arrayLike = this.object.eachArrayWithMinLike(name, numberExamples, size);
        LambdaDslJsonArray dslArray = new LambdaDslJsonArray(arrayLike);
        nestedArray.accept(dslArray);
        arrayLike.closeArray().closeArray();
        return this;
    }

    public LambdaDslObject eachArrayWithMinMaxLike(String name, Integer minSize, Integer maxSize, Consumer<LambdaDslJsonArray> nestedArray) {
        PactDslJsonArray arrayLike = this.object.eachArrayWithMinMaxLike(name, (int)minSize, (int)maxSize);
        LambdaDslJsonArray dslArray = new LambdaDslJsonArray(arrayLike);
        nestedArray.accept(dslArray);
        arrayLike.closeArray().closeArray();
        return this;
    }

    public LambdaDslObject eachArrayWithMinMaxLike(String name, Integer minSize, Integer maxSize, int numberExamples, Consumer<LambdaDslJsonArray> nestedArray) {
        PactDslJsonArray arrayLike = this.object.eachArrayWithMinMaxLike(name, numberExamples, minSize, maxSize);
        LambdaDslJsonArray dslArray = new LambdaDslJsonArray(arrayLike);
        nestedArray.accept(dslArray);
        arrayLike.closeArray().closeArray();
        return this;
    }

    public LambdaDslObject eachKeyMappedToAnArrayLike(String exampleKey, Consumer<LambdaDslObject> nestedObject) {
        PactDslJsonBody objectLike = this.object.eachKeyMappedToAnArrayLike(exampleKey);
        LambdaDslObject dslObject = new LambdaDslObject(objectLike);
        nestedObject.accept(dslObject);
        objectLike.closeObject().closeArray();
        return this;
    }

    public LambdaDslObject eachKeyLike(String exampleKey, Consumer<LambdaDslObject> nestedObject) {
        PactDslJsonBody objectLike = this.object.eachKeyLike(exampleKey);
        LambdaDslObject dslObject = new LambdaDslObject(objectLike);
        nestedObject.accept(dslObject);
        objectLike.closeObject();
        return this;
    }

    public LambdaDslObject eachKeyLike(String exampleKey, PactDslJsonRootValue value) {
        this.object.eachKeyLike(exampleKey, value);
        return this;
    }

    public LambdaDslObject dateExpression(String name, String expression) {
        this.object.dateExpression(name, expression);
        return this;
    }

    public LambdaDslObject dateExpression(String name, String expression, String format) {
        this.object.dateExpression(name, expression, format);
        return this;
    }

    public LambdaDslObject timeExpression(String name, String expression) {
        this.object.timeExpression(name, expression);
        return this;
    }

    public LambdaDslObject timeExpression(String name, String expression, String format) {
        this.object.timeExpression(name, expression, format);
        return this;
    }

    public LambdaDslObject datetimeExpression(String name, String expression) {
        this.object.datetimeExpression(name, expression);
        return this;
    }

    public LambdaDslObject datetimeExpression(String name, String expression, String format) {
        this.object.datetimeExpression(name, expression, format);
        return this;
    }

    public LambdaDslObject unorderedArray(String name, Consumer<LambdaDslJsonArray> nestedArray) {
        PactDslJsonArray pactArray = this.object.unorderedArray(name);
        LambdaDslJsonArray array = new LambdaDslJsonArray(pactArray);
        nestedArray.accept(array);
        pactArray.closeArray();
        return this;
    }

    public LambdaDslObject unorderedMinArray(String name, int size, Consumer<LambdaDslJsonArray> nestedArray) {
        PactDslJsonArray pactArray = this.object.unorderedMinArray(name, size);
        LambdaDslJsonArray array = new LambdaDslJsonArray(pactArray);
        nestedArray.accept(array);
        pactArray.closeArray();
        return this;
    }

    public LambdaDslObject unorderedMaxArray(String name, int size, Consumer<LambdaDslJsonArray> nestedArray) {
        PactDslJsonArray pactArray = this.object.unorderedMaxArray(name, size);
        LambdaDslJsonArray array = new LambdaDslJsonArray(pactArray);
        nestedArray.accept(array);
        pactArray.closeArray();
        return this;
    }

    public LambdaDslObject unorderedMinMaxArray(String name, int minSize, int maxSize, Consumer<LambdaDslJsonArray> nestedArray) {
        PactDslJsonArray pactArray = this.object.unorderedMinMaxArray(name, minSize, maxSize);
        LambdaDslJsonArray array = new LambdaDslJsonArray(pactArray);
        nestedArray.accept(array);
        pactArray.closeArray();
        return this;
    }

    public LambdaDslObject matchUrl(String name, String basePath, Object ... pathFragments) {
        this.object.matchUrl(name, basePath, pathFragments);
        return this;
    }

    public LambdaDslObject matchUrl2(String name, Object ... pathFragments) {
        this.object.matchUrl2(name, pathFragments);
        return this;
    }

    public LambdaDslObject arrayContaining(String name, Consumer<LambdaDslJsonArray> nestedArray) {
        PactDslJsonArray arrayContaining = (PactDslJsonArray)this.object.arrayContaining(name);
        LambdaDslJsonArray dslObject = new LambdaDslJsonArray(arrayContaining);
        nestedArray.accept(dslObject);
        arrayContaining.closeArray();
        return this;
    }
}

