/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.provider;

import au.com.dius.pact.core.model.BrokerUrlSource;
import au.com.dius.pact.core.model.Pact;
import au.com.dius.pact.core.model.PactSource;
import au.com.dius.pact.core.pactbroker.IPactBrokerClient;
import au.com.dius.pact.core.pactbroker.PactBrokerClient;
import au.com.dius.pact.core.pactbroker.PactBrokerClientConfig;
import au.com.dius.pact.core.pactbroker.TestResult;
import au.com.dius.pact.core.support.expressions.SystemPropertyResolver;
import au.com.dius.pact.core.support.expressions.ValueResolver;
import au.com.dius.pact.provider.VerificationReporter;
import com.github.michaelbull.result.Err;
import com.github.michaelbull.result.Ok;
import com.github.michaelbull.result.Result;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003JZ\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\u0010\u0013\u001a\u0004\u0018\u00010\bH\u0002J\b\u0010\u0014\u001a\u00020\u0006H\u0016J\u0010\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J4\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\b2\b\u0010\u0019\u001a\u0004\u0018\u00010\n2\b\u0010\u001a\u001a\u0004\u0018\u00010\bH\u0016JT\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\b2\b\u0010\u0019\u001a\u0004\u0018\u00010\n2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\u0010\u0013\u001a\u0004\u0018\u00010\bH\u0016\u00a8\u0006\u001b"}, d2={"Lau/com/dius/pact/provider/DefaultVerificationReporter;", "Lau/com/dius/pact/provider/VerificationReporter;", "Lmu/KLogging;", "()V", "publishResult", "Lcom/github/michaelbull/result/Result;", "", "", "", "brokerClient", "Lau/com/dius/pact/core/pactbroker/IPactBrokerClient;", "source", "Lau/com/dius/pact/core/model/BrokerUrlSource;", "result", "Lau/com/dius/pact/core/pactbroker/TestResult;", "version", "pact", "Lau/com/dius/pact/core/model/Pact;", "tags", "branch", "publishingResultsDisabled", "resolver", "Lau/com/dius/pact/core/support/expressions/ValueResolver;", "reportResults", "", "client", "tag", "provider"})
public final class DefaultVerificationReporter
extends KLogging
implements VerificationReporter {
    @NotNull
    public static final DefaultVerificationReporter INSTANCE = new DefaultVerificationReporter();

    private DefaultVerificationReporter() {
    }

    @Override
    public void reportResults(@NotNull Pact pact, @NotNull TestResult result2, @NotNull String version2, @Nullable IPactBrokerClient client, @Nullable String tag) {
        Intrinsics.checkNotNullParameter((Object)pact, (String)"pact");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
        CharSequence charSequence = tag;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || charSequence.length() == 0) {
            VerificationReporter.DefaultImpls.reportResults$default(this, pact, result2, version2, client, CollectionsKt.emptyList(), null, 32, null);
        } else {
            VerificationReporter.DefaultImpls.reportResults$default(this, pact, result2, version2, client, CollectionsKt.listOf((Object)tag), null, 32, null);
        }
    }

    @Override
    @NotNull
    public Result<Boolean, List<String>> reportResults(@NotNull Pact pact, @NotNull TestResult result2, @NotNull String version2, @Nullable IPactBrokerClient client, @NotNull List<String> tags, @Nullable String branch) {
        Result<Boolean, List<String>> result3;
        Intrinsics.checkNotNullParameter((Object)pact, (String)"pact");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
        Intrinsics.checkNotNullParameter(tags, (String)"tags");
        PactSource source = pact.getSource();
        if (source instanceof BrokerUrlSource) {
            IPactBrokerClient iPactBrokerClient = client;
            IPactBrokerClient brokerClient = iPactBrokerClient == null ? (IPactBrokerClient)new PactBrokerClient(((BrokerUrlSource)source).getPactBrokerUrl(), MapsKt.toMutableMap((Map)((BrokerUrlSource)source).getOptions()), new PactBrokerClientConfig(0, 0, false, 7, null)) : iPactBrokerClient;
            result3 = this.publishResult(brokerClient, (BrokerUrlSource)source, result2, version2, pact, tags, branch);
        } else {
            this.getLogger().info((Function0)new Function0<Object>(source){
                final /* synthetic */ PactSource $source;
                {
                    this.$source = $source;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Skipping publishing verification results for source " + this.$source;
                }
            });
            result3 = (Result<Boolean, List<String>>)new Ok((Object)false);
        }
        return result3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Result<Boolean, List<String>> publishResult(IPactBrokerClient brokerClient, BrokerUrlSource source, TestResult result2, String version2, Pact pact, List<String> tags, String branch) {
        boolean $i$f$mapError;
        Result $this$mapError$iv;
        Result result3;
        Result publishResult2;
        boolean bl;
        Object object;
        boolean bl2;
        String string = branch;
        if (string == null) {
            bl2 = false;
        } else {
            object = string;
            bl = false;
            bl2 = !StringsKt.isBlank((CharSequence)object);
        }
        Result branchResult = bl2 ? brokerClient.publishProviderBranch(source.getAttributes(), pact.getProvider().getName(), branch, version2) : (Result)new Ok((Object)true);
        object = tags;
        bl = false;
        Result tagsResult = !object.isEmpty() ? brokerClient.publishProviderTags(source.getAttributes(), pact.getProvider().getName(), tags, version2) : (Result)new Ok((Object)true);
        String buildUrl = System.getProperty("pact.verifier.buildUrl");
        CharSequence charSequence = buildUrl;
        boolean bl3 = false;
        boolean bl4 = false;
        Result result4 = publishResult2 = charSequence == null || charSequence.length() == 0 ? brokerClient.publishVerificationResults(source.getAttributes(), result2, version2) : brokerClient.publishVerificationResults(source.getAttributes(), result2, version2, buildUrl);
        if (publishResult2 instanceof Err) {
            this.getLogger().error((Function0)new Function0<Object>((Result<Boolean, String>)publishResult2){
                final /* synthetic */ Result<Boolean, String> $publishResult;
                {
                    this.$publishResult = $publishResult;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Failed to publish verification results - " + ((Err)this.$publishResult).getError();
                }
            });
        } else {
            this.getLogger().info((Function0)new Function0<Object>(result2, pact){
                final /* synthetic */ TestResult $result;
                final /* synthetic */ Pact $pact;
                {
                    this.$result = $result;
                    this.$pact = $pact;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Published verification result of '" + this.$result + "' for consumer '" + this.$pact.getConsumer() + "'";
                }
            });
        }
        if (tagsResult instanceof Err && branchResult instanceof Ok && publishResult2 instanceof Ok) {
            result3 = tagsResult;
            return result3;
        } else if (branchResult instanceof Err && tagsResult instanceof Ok && publishResult2 instanceof Ok) {
            $this$mapError$iv = branchResult;
            $i$f$mapError = false;
            bl4 = false;
            Result result5 = $this$mapError$iv;
            if (result5 instanceof Ok) {
                result3 = $this$mapError$iv;
                return result3;
            } else {
                List list;
                if (!(result5 instanceof Err)) throw new NoWhenBranchMatchedException();
                String it = (String)((Err)$this$mapError$iv).getError();
                boolean bl5 = false;
                List list2 = list = CollectionsKt.listOf((Object)it);
                result3 = (Result)new Err((Object)list2);
            }
            return result3;
        } else if (tagsResult instanceof Err && branchResult instanceof Err && publishResult2 instanceof Ok) {
            result3 = (Result)new Err((Object)CollectionsKt.plus((Collection)((Collection)((Err)tagsResult).getError()), (Object)((Err)branchResult).getError()));
            return result3;
        } else if (tagsResult instanceof Err && branchResult instanceof Err && publishResult2 instanceof Err) {
            result3 = (Result)new Err((Object)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)((Collection)((Err)tagsResult).getError()), (Object)((Err)branchResult).getError()), (Object)((Err)publishResult2).getError()));
            return result3;
        } else {
            $this$mapError$iv = publishResult2;
            $i$f$mapError = false;
            bl4 = false;
            Result result6 = $this$mapError$iv;
            if (result6 instanceof Ok) {
                result3 = $this$mapError$iv;
                return result3;
            } else {
                List list;
                if (!(result6 instanceof Err)) throw new NoWhenBranchMatchedException();
                String it = (String)((Err)$this$mapError$iv).getError();
                boolean bl6 = false;
                List list3 = list = CollectionsKt.listOf((Object)it);
                result3 = (Result)new Err((Object)list3);
            }
        }
        return result3;
    }

    @Override
    public boolean publishingResultsDisabled() {
        return this.publishingResultsDisabled((ValueResolver)SystemPropertyResolver.INSTANCE);
    }

    @Override
    public boolean publishingResultsDisabled(@NotNull ValueResolver resolver) {
        String string;
        String property;
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        String string2 = property = resolver.resolveValue("pact.verifier.publishResults", "false");
        if (string2 == null) {
            string = null;
        } else {
            String string3 = string2;
            boolean bl = false;
            String string4 = string3.toLowerCase();
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
        }
        return !Intrinsics.areEqual(string, (Object)"true");
    }
}

