/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.reflect.AbstractInvocationHandler;
import com.lambdaworks.redis.AbstractRedisClient;
import com.lambdaworks.redis.LettuceFutures;
import com.lambdaworks.redis.RedisAsyncConnectionImpl;
import com.lambdaworks.redis.RedisChannelHandler;
import com.lambdaworks.redis.RedisClusterAsyncConnection;
import com.lambdaworks.redis.RedisClusterConnection;
import com.lambdaworks.redis.RedisConnection;
import com.lambdaworks.redis.RedisException;
import com.lambdaworks.redis.protocol.Command;
import com.lambdaworks.redis.protocol.RedisCommand;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

class FutureSyncInvocationHandler<K, V>
extends AbstractInvocationHandler {
    private final RedisChannelHandler<K, V> connection;
    protected long timeout;
    protected TimeUnit unit;
    private LoadingCache<Method, Method> methodCache;

    public FutureSyncInvocationHandler(final RedisChannelHandler<K, V> connection) {
        this.connection = connection;
        this.timeout = connection.timeout;
        this.unit = connection.unit;
        this.methodCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Method, Method>(){

            public Method load(Method key) throws Exception {
                return connection.getClass().getMethod(key.getName(), key.getParameterTypes());
            }
        });
    }

    protected Object handleInvocation(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            if (method.getName().equals("setTimeout")) {
                this.setTimeout((Long)args[0], (TimeUnit)((Object)args[1]));
                return null;
            }
            Method targetMethod = (Method)this.methodCache.get((Object)method);
            Object result = targetMethod.invoke(this.connection, args);
            if (result instanceof RedisCommand) {
                Command command;
                RedisCommand redisCommand = (RedisCommand)result;
                if (!method.getName().equals("exec") && !method.getName().equals("multi") && this.connection instanceof RedisAsyncConnectionImpl && ((RedisAsyncConnectionImpl)this.connection).isMulti()) {
                    return null;
                }
                Object awaitedResult = LettuceFutures.awaitOrCancel(redisCommand, this.timeout, this.unit);
                if (redisCommand instanceof Command && (command = (Command)redisCommand).getException() != null) {
                    throw new RedisException(command.getException());
                }
                if (redisCommand instanceof Future && redisCommand.isDone()) {
                    try {
                        redisCommand.get();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw e;
                    }
                    catch (ExecutionException e) {
                        throw new RedisException(e.getCause());
                    }
                }
                return awaitedResult;
            }
            if (result instanceof RedisClusterAsyncConnection) {
                return AbstractRedisClient.syncHandler((RedisChannelHandler)result, RedisConnection.class, RedisClusterConnection.class);
            }
            return result;
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    private void setTimeout(long timeout, TimeUnit unit) {
        this.timeout = timeout;
        this.unit = unit;
    }
}

