/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis;

import com.lambdaworks.redis.RedisCommandExecutionException;
import com.lambdaworks.redis.RedisCommandInterruptedException;
import com.lambdaworks.redis.RedisCommandTimeoutException;
import com.lambdaworks.redis.protocol.CommandOutput;
import com.lambdaworks.redis.protocol.RedisCommand;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class LettuceFutures {
    private LettuceFutures() {
    }

    public static boolean awaitAll(long timeout, TimeUnit unit, Future<?> ... futures) {
        boolean complete;
        try {
            long nanos = unit.toNanos(timeout);
            long time = System.nanoTime();
            for (Future<?> f : futures) {
                if (nanos < 0L) {
                    return false;
                }
                f.get(nanos, TimeUnit.NANOSECONDS);
                long now = System.nanoTime();
                nanos -= now - time;
                time = now;
            }
            complete = true;
        }
        catch (TimeoutException e) {
            complete = false;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RedisCommandInterruptedException(e);
        }
        catch (Exception e) {
            throw new RedisCommandExecutionException(e);
        }
        return complete;
    }

    public static <K, V, T> T awaitOrCancel(RedisCommand<K, V, T> cmd, long timeout, TimeUnit unit) {
        return LettuceFutures.await(cmd, timeout, unit);
    }

    @Deprecated
    public static <K, V, T> T await(RedisCommand<K, V, T> cmd, long timeout, TimeUnit unit) {
        if (!cmd.await(timeout, unit)) {
            cmd.cancel(true);
            throw new RedisCommandTimeoutException();
        }
        CommandOutput<K, V, T> output = cmd.getOutput();
        if (output.hasError()) {
            throw new RedisCommandExecutionException(output.getError());
        }
        return output.get();
    }
}

