/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.cluster;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.net.HostAndPort;
import com.lambdaworks.redis.LettuceStrings;
import com.lambdaworks.redis.ReadFrom;
import com.lambdaworks.redis.RedisAsyncConnectionImpl;
import com.lambdaworks.redis.RedisChannelHandler;
import com.lambdaworks.redis.RedisChannelWriter;
import com.lambdaworks.redis.cluster.ClusterCommand;
import com.lambdaworks.redis.cluster.ClusterConnectionProvider;
import com.lambdaworks.redis.cluster.ReadOnlyCommands;
import com.lambdaworks.redis.cluster.SlotHash;
import com.lambdaworks.redis.cluster.models.partitions.Partitions;
import com.lambdaworks.redis.protocol.Command;
import com.lambdaworks.redis.protocol.CommandArgs;
import com.lambdaworks.redis.protocol.CommandKeyword;
import com.lambdaworks.redis.protocol.ProtocolKeyword;
import com.lambdaworks.redis.protocol.RedisCommand;
import java.util.List;

class ClusterDistributionChannelWriter<K, V>
implements RedisChannelWriter<K, V> {
    private RedisChannelWriter<K, V> defaultWriter;
    private ClusterConnectionProvider clusterConnectionProvider;
    private boolean closed = false;
    private int executionLimit = 5;

    public ClusterDistributionChannelWriter(RedisChannelWriter<K, V> defaultWriter) {
        this.defaultWriter = defaultWriter;
    }

    @Override
    public <T> RedisCommand<K, V, T> write(RedisCommand<K, V, T> command) {
        RedisAsyncConnectionImpl connection;
        ClusterCommand clusterCommand;
        Command singleCommand;
        Preconditions.checkArgument((command != null ? 1 : 0) != 0, (Object)"command must not be null");
        RedisCommand<K, V, T> commandToSend = command;
        CommandArgs<K, V> args = command.getArgs();
        RedisChannelWriter<K, V> channelWriter = null;
        if (command instanceof Command && !(singleCommand = (Command)command).isMulti()) {
            commandToSend = new ClusterCommand(singleCommand, this, this.executionLimit);
        }
        if (commandToSend instanceof ClusterCommand && !(clusterCommand = (ClusterCommand)commandToSend).isDone()) {
            if (clusterCommand.isMoved()) {
                HostAndPort moveTarget = this.getMoveTarget(clusterCommand.getError());
                commandToSend.getOutput().setError((String)null);
                connection = this.clusterConnectionProvider.getConnection(ClusterConnectionProvider.Intent.WRITE, moveTarget.getHostText(), moveTarget.getPort());
                channelWriter = connection.getChannelWriter();
            }
            if (clusterCommand.isAsk()) {
                HostAndPort askTarget = this.getAskTarget(clusterCommand.getError());
                commandToSend.getOutput().setError((String)null);
                connection = this.clusterConnectionProvider.getConnection(ClusterConnectionProvider.Intent.WRITE, askTarget.getHostText(), askTarget.getPort());
                channelWriter = connection.getChannelWriter();
                connection.asking();
            }
        }
        if (channelWriter == null && args != null && args.getEncodedKey() != null) {
            int hash = this.getHash(args.getEncodedKey());
            ClusterConnectionProvider.Intent intent = this.getIntent(command.getType());
            connection = this.clusterConnectionProvider.getConnection(intent, hash);
            channelWriter = connection.getChannelWriter();
        }
        if (channelWriter instanceof ClusterDistributionChannelWriter) {
            ClusterDistributionChannelWriter writer = (ClusterDistributionChannelWriter)channelWriter;
            channelWriter = writer.defaultWriter;
        }
        if (command.getOutput() != null) {
            commandToSend.getOutput().setError((String)null);
        }
        if (channelWriter != null && channelWriter != this && channelWriter != this.defaultWriter) {
            return channelWriter.write(commandToSend);
        }
        return this.defaultWriter.write(commandToSend);
    }

    private ClusterConnectionProvider.Intent getIntent(ProtocolKeyword type) {
        for (ProtocolKeyword readOnlyCommand : ReadOnlyCommands.READ_ONLY_COMMANDS) {
            if (readOnlyCommand != type) continue;
            return ClusterConnectionProvider.Intent.READ;
        }
        return ClusterConnectionProvider.Intent.WRITE;
    }

    private HostAndPort getMoveTarget(String errorMessage) {
        Preconditions.checkArgument((boolean)LettuceStrings.isNotEmpty(errorMessage), (Object)"errorMessage must not be empty");
        Preconditions.checkArgument((boolean)errorMessage.startsWith(CommandKeyword.MOVED.name()), (Object)("errorMessage must start with " + CommandKeyword.MOVED));
        List movedMessageParts = Splitter.on((char)' ').splitToList((CharSequence)errorMessage);
        Preconditions.checkArgument((movedMessageParts.size() >= 3 ? 1 : 0) != 0, (Object)("errorMessage must consist of 3 tokens (" + movedMessageParts + ")"));
        return HostAndPort.fromString((String)((String)movedMessageParts.get(2)));
    }

    private HostAndPort getAskTarget(String errorMessage) {
        Preconditions.checkArgument((boolean)LettuceStrings.isNotEmpty(errorMessage), (Object)"errorMessage must not be empty");
        Preconditions.checkArgument((boolean)errorMessage.startsWith(CommandKeyword.ASK.name()), (Object)("errorMessage must start with " + CommandKeyword.ASK));
        List movedMessageParts = Splitter.on((char)' ').splitToList((CharSequence)errorMessage);
        Preconditions.checkArgument((movedMessageParts.size() >= 3 ? 1 : 0) != 0, (Object)("errorMessage must consist of 3 tokens (" + movedMessageParts + ")"));
        return HostAndPort.fromString((String)((String)movedMessageParts.get(2)));
    }

    protected int getHash(byte[] encodedKey) {
        return SlotHash.getSlot(encodedKey);
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.defaultWriter != null) {
            this.defaultWriter.close();
            this.defaultWriter = null;
        }
        if (this.clusterConnectionProvider != null) {
            this.clusterConnectionProvider.close();
            this.clusterConnectionProvider = null;
        }
    }

    @Override
    public void setRedisChannelHandler(RedisChannelHandler<K, V> redisChannelHandler) {
        this.defaultWriter.setRedisChannelHandler(redisChannelHandler);
    }

    @Override
    public void setAutoFlushCommands(boolean autoFlush) {
        this.getClusterConnectionProvider().setAutoFlushCommands(autoFlush);
    }

    @Override
    public void flushCommands() {
        this.getClusterConnectionProvider().flushCommands();
    }

    public ClusterConnectionProvider getClusterConnectionProvider() {
        return this.clusterConnectionProvider;
    }

    @Override
    public void reset() {
        this.defaultWriter.reset();
        this.clusterConnectionProvider.reset();
    }

    public void setClusterConnectionProvider(ClusterConnectionProvider clusterConnectionProvider) {
        this.clusterConnectionProvider = clusterConnectionProvider;
    }

    public void setPartitions(Partitions partitions) {
        this.clusterConnectionProvider.setPartitions(partitions);
    }

    public void setReadFrom(ReadFrom readFrom) {
        this.clusterConnectionProvider.setReadFrom(readFrom);
    }

    public ReadFrom getReadFrom() {
        return this.clusterConnectionProvider.getReadFrom();
    }
}

