/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v23.datatype.CE;
import ca.uhn.hl7v2.model.v23.datatype.EI;
import ca.uhn.hl7v2.model.v23.datatype.ID;
import ca.uhn.hl7v2.model.v23.datatype.NM;
import ca.uhn.hl7v2.model.v23.datatype.ST;
import ca.uhn.hl7v2.model.v23.datatype.TQ;
import ca.uhn.hl7v2.model.v23.datatype.TS;
import ca.uhn.hl7v2.model.v23.datatype.XPN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class GOL
extends AbstractSegment {
    public GOL(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ID.class, true, 1, 2, new Object[]{this.getMessage(), new Integer(287)}, "Action Code");
            this.add(TS.class, true, 1, 26, new Object[]{this.getMessage()}, "Action Date/Time");
            this.add(CE.class, true, 1, 80, new Object[]{this.getMessage()}, "Goal ID");
            this.add(EI.class, true, 1, 60, new Object[]{this.getMessage()}, "Goal Instance ID");
            this.add(EI.class, false, 1, 60, new Object[]{this.getMessage()}, "Episode of Care ID");
            this.add(NM.class, false, 1, 60, new Object[]{this.getMessage()}, "Goal List Priority");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Goal Established Date/Time");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Expected Goal Achievement Date/Time");
            this.add(CE.class, false, 1, 80, new Object[]{this.getMessage()}, "Goal Classification");
            this.add(CE.class, false, 1, 80, new Object[]{this.getMessage()}, "Goal Management Discipline");
            this.add(CE.class, false, 1, 80, new Object[]{this.getMessage()}, "Current Goal Review Status");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Current Goal Review Date/Time");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Next Goal Review Date/Time");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Previous Goal Review Date/Time");
            this.add(TQ.class, false, 1, 200, new Object[]{this.getMessage()}, "Goal Review Interval");
            this.add(CE.class, false, 1, 80, new Object[]{this.getMessage()}, "Goal Evaluation");
            this.add(ST.class, false, 0, 300, new Object[]{this.getMessage()}, "Goal Evaluation Comment");
            this.add(CE.class, false, 1, 80, new Object[]{this.getMessage()}, "Goal Life Cycle Status");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Goal Life Cycle Status Date/Time");
            this.add(CE.class, false, 0, 80, new Object[]{this.getMessage()}, "Goal Target Type");
            this.add(XPN.class, false, 0, 80, new Object[]{this.getMessage()}, "Goal Target Name");
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating GOL - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public ID getActionCode() {
        ID retVal = (ID)this.getTypedField(1, 0);
        return retVal;
    }

    public ID getGol1_ActionCode() {
        ID retVal = (ID)this.getTypedField(1, 0);
        return retVal;
    }

    public TS getActionDateTime() {
        TS retVal = (TS)this.getTypedField(2, 0);
        return retVal;
    }

    public TS getGol2_ActionDateTime() {
        TS retVal = (TS)this.getTypedField(2, 0);
        return retVal;
    }

    public CE getGoalID() {
        CE retVal = (CE)this.getTypedField(3, 0);
        return retVal;
    }

    public CE getGol3_GoalID() {
        CE retVal = (CE)this.getTypedField(3, 0);
        return retVal;
    }

    public EI getGoalInstanceID() {
        EI retVal = (EI)this.getTypedField(4, 0);
        return retVal;
    }

    public EI getGol4_GoalInstanceID() {
        EI retVal = (EI)this.getTypedField(4, 0);
        return retVal;
    }

    public EI getEpisodeOfCareID() {
        EI retVal = (EI)this.getTypedField(5, 0);
        return retVal;
    }

    public EI getGol5_EpisodeOfCareID() {
        EI retVal = (EI)this.getTypedField(5, 0);
        return retVal;
    }

    public NM getGoalListPriority() {
        NM retVal = (NM)this.getTypedField(6, 0);
        return retVal;
    }

    public NM getGol6_GoalListPriority() {
        NM retVal = (NM)this.getTypedField(6, 0);
        return retVal;
    }

    public TS getGoalEstablishedDateTime() {
        TS retVal = (TS)this.getTypedField(7, 0);
        return retVal;
    }

    public TS getGol7_GoalEstablishedDateTime() {
        TS retVal = (TS)this.getTypedField(7, 0);
        return retVal;
    }

    public TS getExpectedGoalAchievementDateTime() {
        TS retVal = (TS)this.getTypedField(8, 0);
        return retVal;
    }

    public TS getGol8_ExpectedGoalAchievementDateTime() {
        TS retVal = (TS)this.getTypedField(8, 0);
        return retVal;
    }

    public CE getGoalClassification() {
        CE retVal = (CE)this.getTypedField(9, 0);
        return retVal;
    }

    public CE getGol9_GoalClassification() {
        CE retVal = (CE)this.getTypedField(9, 0);
        return retVal;
    }

    public CE getGoalManagementDiscipline() {
        CE retVal = (CE)this.getTypedField(10, 0);
        return retVal;
    }

    public CE getGol10_GoalManagementDiscipline() {
        CE retVal = (CE)this.getTypedField(10, 0);
        return retVal;
    }

    public CE getCurrentGoalReviewStatus() {
        CE retVal = (CE)this.getTypedField(11, 0);
        return retVal;
    }

    public CE getGol11_CurrentGoalReviewStatus() {
        CE retVal = (CE)this.getTypedField(11, 0);
        return retVal;
    }

    public TS getCurrentGoalReviewDateTime() {
        TS retVal = (TS)this.getTypedField(12, 0);
        return retVal;
    }

    public TS getGol12_CurrentGoalReviewDateTime() {
        TS retVal = (TS)this.getTypedField(12, 0);
        return retVal;
    }

    public TS getNextGoalReviewDateTime() {
        TS retVal = (TS)this.getTypedField(13, 0);
        return retVal;
    }

    public TS getGol13_NextGoalReviewDateTime() {
        TS retVal = (TS)this.getTypedField(13, 0);
        return retVal;
    }

    public TS getPreviousGoalReviewDateTime() {
        TS retVal = (TS)this.getTypedField(14, 0);
        return retVal;
    }

    public TS getGol14_PreviousGoalReviewDateTime() {
        TS retVal = (TS)this.getTypedField(14, 0);
        return retVal;
    }

    public TQ getGoalReviewInterval() {
        TQ retVal = (TQ)this.getTypedField(15, 0);
        return retVal;
    }

    public TQ getGol15_GoalReviewInterval() {
        TQ retVal = (TQ)this.getTypedField(15, 0);
        return retVal;
    }

    public CE getGoalEvaluation() {
        CE retVal = (CE)this.getTypedField(16, 0);
        return retVal;
    }

    public CE getGol16_GoalEvaluation() {
        CE retVal = (CE)this.getTypedField(16, 0);
        return retVal;
    }

    public ST[] getGoalEvaluationComment() {
        ST[] retVal = (ST[])this.getTypedField(17, (Type[])new ST[0]);
        return retVal;
    }

    public ST[] getGol17_GoalEvaluationComment() {
        ST[] retVal = (ST[])this.getTypedField(17, (Type[])new ST[0]);
        return retVal;
    }

    public int getGoalEvaluationCommentReps() {
        return this.getReps(17);
    }

    public ST getGoalEvaluationComment(int rep) {
        ST retVal = (ST)this.getTypedField(17, rep);
        return retVal;
    }

    public ST getGol17_GoalEvaluationComment(int rep) {
        ST retVal = (ST)this.getTypedField(17, rep);
        return retVal;
    }

    public int getGol17_GoalEvaluationCommentReps() {
        return this.getReps(17);
    }

    public ST insertGoalEvaluationComment(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(17, rep);
    }

    public ST insertGol17_GoalEvaluationComment(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(17, rep);
    }

    public ST removeGoalEvaluationComment(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(17, rep);
    }

    public ST removeGol17_GoalEvaluationComment(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(17, rep);
    }

    public CE getGoalLifeCycleStatus() {
        CE retVal = (CE)this.getTypedField(18, 0);
        return retVal;
    }

    public CE getGol18_GoalLifeCycleStatus() {
        CE retVal = (CE)this.getTypedField(18, 0);
        return retVal;
    }

    public TS getGoalLifeCycleStatusDateTime() {
        TS retVal = (TS)this.getTypedField(19, 0);
        return retVal;
    }

    public TS getGol19_GoalLifeCycleStatusDateTime() {
        TS retVal = (TS)this.getTypedField(19, 0);
        return retVal;
    }

    public CE[] getGoalTargetType() {
        CE[] retVal = (CE[])this.getTypedField(20, (Type[])new CE[0]);
        return retVal;
    }

    public CE[] getGol20_GoalTargetType() {
        CE[] retVal = (CE[])this.getTypedField(20, (Type[])new CE[0]);
        return retVal;
    }

    public int getGoalTargetTypeReps() {
        return this.getReps(20);
    }

    public CE getGoalTargetType(int rep) {
        CE retVal = (CE)this.getTypedField(20, rep);
        return retVal;
    }

    public CE getGol20_GoalTargetType(int rep) {
        CE retVal = (CE)this.getTypedField(20, rep);
        return retVal;
    }

    public int getGol20_GoalTargetTypeReps() {
        return this.getReps(20);
    }

    public CE insertGoalTargetType(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(20, rep);
    }

    public CE insertGol20_GoalTargetType(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(20, rep);
    }

    public CE removeGoalTargetType(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(20, rep);
    }

    public CE removeGol20_GoalTargetType(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(20, rep);
    }

    public XPN[] getGoalTargetName() {
        XPN[] retVal = (XPN[])this.getTypedField(21, (Type[])new XPN[0]);
        return retVal;
    }

    public XPN[] getGol21_GoalTargetName() {
        XPN[] retVal = (XPN[])this.getTypedField(21, (Type[])new XPN[0]);
        return retVal;
    }

    public int getGoalTargetNameReps() {
        return this.getReps(21);
    }

    public XPN getGoalTargetName(int rep) {
        XPN retVal = (XPN)this.getTypedField(21, rep);
        return retVal;
    }

    public XPN getGol21_GoalTargetName(int rep) {
        XPN retVal = (XPN)this.getTypedField(21, rep);
        return retVal;
    }

    public int getGol21_GoalTargetNameReps() {
        return this.getReps(21);
    }

    public XPN insertGoalTargetName(int rep) throws HL7Exception {
        return (XPN)super.insertRepetition(21, rep);
    }

    public XPN insertGol21_GoalTargetName(int rep) throws HL7Exception {
        return (XPN)super.insertRepetition(21, rep);
    }

    public XPN removeGoalTargetName(int rep) throws HL7Exception {
        return (XPN)super.removeRepetition(21, rep);
    }

    public XPN removeGol21_GoalTargetName(int rep) throws HL7Exception {
        return (XPN)super.removeRepetition(21, rep);
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new ID(this.getMessage(), new Integer(287));
            }
            case 1: {
                return new TS(this.getMessage());
            }
            case 2: {
                return new CE(this.getMessage());
            }
            case 3: {
                return new EI(this.getMessage());
            }
            case 4: {
                return new EI(this.getMessage());
            }
            case 5: {
                return new NM(this.getMessage());
            }
            case 6: {
                return new TS(this.getMessage());
            }
            case 7: {
                return new TS(this.getMessage());
            }
            case 8: {
                return new CE(this.getMessage());
            }
            case 9: {
                return new CE(this.getMessage());
            }
            case 10: {
                return new CE(this.getMessage());
            }
            case 11: {
                return new TS(this.getMessage());
            }
            case 12: {
                return new TS(this.getMessage());
            }
            case 13: {
                return new TS(this.getMessage());
            }
            case 14: {
                return new TQ(this.getMessage());
            }
            case 15: {
                return new CE(this.getMessage());
            }
            case 16: {
                return new ST(this.getMessage());
            }
            case 17: {
                return new CE(this.getMessage());
            }
            case 18: {
                return new TS(this.getMessage());
            }
            case 19: {
                return new CE(this.getMessage());
            }
            case 20: {
                return new XPN(this.getMessage());
            }
        }
        return null;
    }
}

