/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v231.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v231.datatype.CE;
import ca.uhn.hl7v2.model.v231.datatype.CX;
import ca.uhn.hl7v2.model.v231.datatype.DIN;
import ca.uhn.hl7v2.model.v231.datatype.DLN;
import ca.uhn.hl7v2.model.v231.datatype.DT;
import ca.uhn.hl7v2.model.v231.datatype.ID;
import ca.uhn.hl7v2.model.v231.datatype.IS;
import ca.uhn.hl7v2.model.v231.datatype.JCC;
import ca.uhn.hl7v2.model.v231.datatype.ST;
import ca.uhn.hl7v2.model.v231.datatype.TS;
import ca.uhn.hl7v2.model.v231.datatype.XAD;
import ca.uhn.hl7v2.model.v231.datatype.XPN;
import ca.uhn.hl7v2.model.v231.datatype.XTN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class STF
extends AbstractSegment {
    public STF(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(CE.class, true, 1, 60, new Object[]{this.getMessage()}, "Primary Key Value - STF");
            this.add(CX.class, false, 0, 60, new Object[]{this.getMessage()}, "Staff ID Code");
            this.add(XPN.class, false, 0, 48, new Object[]{this.getMessage()}, "Staff Name");
            this.add(IS.class, false, 0, 2, new Object[]{this.getMessage(), new Integer(182)}, "Staff Type");
            this.add(IS.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(1)}, "Sex");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Date/Time Of Birth");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(183)}, "Active/Inactive Flag");
            this.add(CE.class, false, 0, 200, new Object[]{this.getMessage()}, "Department");
            this.add(CE.class, false, 0, 200, new Object[]{this.getMessage()}, "Hospital Service");
            this.add(XTN.class, false, 0, 40, new Object[]{this.getMessage()}, "Phone");
            this.add(XAD.class, false, 0, 106, new Object[]{this.getMessage()}, "Office/Home Address");
            this.add(DIN.class, false, 0, 26, new Object[]{this.getMessage()}, "Institution Activation Date");
            this.add(DIN.class, false, 0, 26, new Object[]{this.getMessage()}, "Institution Inactivation Date");
            this.add(CE.class, false, 0, 60, new Object[]{this.getMessage()}, "Backup Person ID");
            this.add(ST.class, false, 0, 40, new Object[]{this.getMessage()}, "E-Mail Address");
            this.add(CE.class, false, 1, 200, new Object[]{this.getMessage()}, "Preferred Method Of Contact");
            this.add(CE.class, false, 1, 80, new Object[]{this.getMessage()}, "Marital Status");
            this.add(ST.class, false, 1, 20, new Object[]{this.getMessage()}, "Job Title");
            this.add(JCC.class, false, 1, 20, new Object[]{this.getMessage()}, "Job Code/Class");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(66)}, "Employment Status");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Additional Insured on  Auto");
            this.add(DLN.class, false, 1, 25, new Object[]{this.getMessage()}, "Driver\u2019s License Number - Staff");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Copy  Auto Ins");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage()}, "Auto Ins. Expires");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage()}, "Date Last DMV Review");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage()}, "Date Next DMV Review");
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating STF - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public CE getPrimaryKeyValueSTF() {
        CE retVal = (CE)this.getTypedField(1, 0);
        return retVal;
    }

    public CE getStf1_PrimaryKeyValueSTF() {
        CE retVal = (CE)this.getTypedField(1, 0);
        return retVal;
    }

    public CX[] getStaffIDCode() {
        CX[] retVal = (CX[])this.getTypedField(2, (Type[])new CX[0]);
        return retVal;
    }

    public CX[] getStf2_StaffIDCode() {
        CX[] retVal = (CX[])this.getTypedField(2, (Type[])new CX[0]);
        return retVal;
    }

    public int getStaffIDCodeReps() {
        return this.getReps(2);
    }

    public CX getStaffIDCode(int rep) {
        CX retVal = (CX)this.getTypedField(2, rep);
        return retVal;
    }

    public CX getStf2_StaffIDCode(int rep) {
        CX retVal = (CX)this.getTypedField(2, rep);
        return retVal;
    }

    public int getStf2_StaffIDCodeReps() {
        return this.getReps(2);
    }

    public CX insertStaffIDCode(int rep) throws HL7Exception {
        return (CX)super.insertRepetition(2, rep);
    }

    public CX insertStf2_StaffIDCode(int rep) throws HL7Exception {
        return (CX)super.insertRepetition(2, rep);
    }

    public CX removeStaffIDCode(int rep) throws HL7Exception {
        return (CX)super.removeRepetition(2, rep);
    }

    public CX removeStf2_StaffIDCode(int rep) throws HL7Exception {
        return (CX)super.removeRepetition(2, rep);
    }

    public XPN[] getStaffName() {
        XPN[] retVal = (XPN[])this.getTypedField(3, (Type[])new XPN[0]);
        return retVal;
    }

    public XPN[] getStf3_StaffName() {
        XPN[] retVal = (XPN[])this.getTypedField(3, (Type[])new XPN[0]);
        return retVal;
    }

    public int getStaffNameReps() {
        return this.getReps(3);
    }

    public XPN getStaffName(int rep) {
        XPN retVal = (XPN)this.getTypedField(3, rep);
        return retVal;
    }

    public XPN getStf3_StaffName(int rep) {
        XPN retVal = (XPN)this.getTypedField(3, rep);
        return retVal;
    }

    public int getStf3_StaffNameReps() {
        return this.getReps(3);
    }

    public XPN insertStaffName(int rep) throws HL7Exception {
        return (XPN)super.insertRepetition(3, rep);
    }

    public XPN insertStf3_StaffName(int rep) throws HL7Exception {
        return (XPN)super.insertRepetition(3, rep);
    }

    public XPN removeStaffName(int rep) throws HL7Exception {
        return (XPN)super.removeRepetition(3, rep);
    }

    public XPN removeStf3_StaffName(int rep) throws HL7Exception {
        return (XPN)super.removeRepetition(3, rep);
    }

    public IS[] getStaffType() {
        IS[] retVal = (IS[])this.getTypedField(4, (Type[])new IS[0]);
        return retVal;
    }

    public IS[] getStf4_StaffType() {
        IS[] retVal = (IS[])this.getTypedField(4, (Type[])new IS[0]);
        return retVal;
    }

    public int getStaffTypeReps() {
        return this.getReps(4);
    }

    public IS getStaffType(int rep) {
        IS retVal = (IS)this.getTypedField(4, rep);
        return retVal;
    }

    public IS getStf4_StaffType(int rep) {
        IS retVal = (IS)this.getTypedField(4, rep);
        return retVal;
    }

    public int getStf4_StaffTypeReps() {
        return this.getReps(4);
    }

    public IS insertStaffType(int rep) throws HL7Exception {
        return (IS)super.insertRepetition(4, rep);
    }

    public IS insertStf4_StaffType(int rep) throws HL7Exception {
        return (IS)super.insertRepetition(4, rep);
    }

    public IS removeStaffType(int rep) throws HL7Exception {
        return (IS)super.removeRepetition(4, rep);
    }

    public IS removeStf4_StaffType(int rep) throws HL7Exception {
        return (IS)super.removeRepetition(4, rep);
    }

    public IS getSex() {
        IS retVal = (IS)this.getTypedField(5, 0);
        return retVal;
    }

    public IS getStf5_Sex() {
        IS retVal = (IS)this.getTypedField(5, 0);
        return retVal;
    }

    public TS getDateTimeOfBirth() {
        TS retVal = (TS)this.getTypedField(6, 0);
        return retVal;
    }

    public TS getStf6_DateTimeOfBirth() {
        TS retVal = (TS)this.getTypedField(6, 0);
        return retVal;
    }

    public ID getActiveInactiveFlag() {
        ID retVal = (ID)this.getTypedField(7, 0);
        return retVal;
    }

    public ID getStf7_ActiveInactiveFlag() {
        ID retVal = (ID)this.getTypedField(7, 0);
        return retVal;
    }

    public CE[] getDepartment() {
        CE[] retVal = (CE[])this.getTypedField(8, (Type[])new CE[0]);
        return retVal;
    }

    public CE[] getStf8_Department() {
        CE[] retVal = (CE[])this.getTypedField(8, (Type[])new CE[0]);
        return retVal;
    }

    public int getDepartmentReps() {
        return this.getReps(8);
    }

    public CE getDepartment(int rep) {
        CE retVal = (CE)this.getTypedField(8, rep);
        return retVal;
    }

    public CE getStf8_Department(int rep) {
        CE retVal = (CE)this.getTypedField(8, rep);
        return retVal;
    }

    public int getStf8_DepartmentReps() {
        return this.getReps(8);
    }

    public CE insertDepartment(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(8, rep);
    }

    public CE insertStf8_Department(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(8, rep);
    }

    public CE removeDepartment(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(8, rep);
    }

    public CE removeStf8_Department(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(8, rep);
    }

    public CE[] getHospitalService() {
        CE[] retVal = (CE[])this.getTypedField(9, (Type[])new CE[0]);
        return retVal;
    }

    public CE[] getStf9_HospitalService() {
        CE[] retVal = (CE[])this.getTypedField(9, (Type[])new CE[0]);
        return retVal;
    }

    public int getHospitalServiceReps() {
        return this.getReps(9);
    }

    public CE getHospitalService(int rep) {
        CE retVal = (CE)this.getTypedField(9, rep);
        return retVal;
    }

    public CE getStf9_HospitalService(int rep) {
        CE retVal = (CE)this.getTypedField(9, rep);
        return retVal;
    }

    public int getStf9_HospitalServiceReps() {
        return this.getReps(9);
    }

    public CE insertHospitalService(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(9, rep);
    }

    public CE insertStf9_HospitalService(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(9, rep);
    }

    public CE removeHospitalService(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(9, rep);
    }

    public CE removeStf9_HospitalService(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(9, rep);
    }

    public XTN[] getPhone() {
        XTN[] retVal = (XTN[])this.getTypedField(10, (Type[])new XTN[0]);
        return retVal;
    }

    public XTN[] getStf10_Phone() {
        XTN[] retVal = (XTN[])this.getTypedField(10, (Type[])new XTN[0]);
        return retVal;
    }

    public int getPhoneReps() {
        return this.getReps(10);
    }

    public XTN getPhone(int rep) {
        XTN retVal = (XTN)this.getTypedField(10, rep);
        return retVal;
    }

    public XTN getStf10_Phone(int rep) {
        XTN retVal = (XTN)this.getTypedField(10, rep);
        return retVal;
    }

    public int getStf10_PhoneReps() {
        return this.getReps(10);
    }

    public XTN insertPhone(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(10, rep);
    }

    public XTN insertStf10_Phone(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(10, rep);
    }

    public XTN removePhone(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(10, rep);
    }

    public XTN removeStf10_Phone(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(10, rep);
    }

    public XAD[] getOfficeHomeAddress() {
        XAD[] retVal = (XAD[])this.getTypedField(11, (Type[])new XAD[0]);
        return retVal;
    }

    public XAD[] getStf11_OfficeHomeAddress() {
        XAD[] retVal = (XAD[])this.getTypedField(11, (Type[])new XAD[0]);
        return retVal;
    }

    public int getOfficeHomeAddressReps() {
        return this.getReps(11);
    }

    public XAD getOfficeHomeAddress(int rep) {
        XAD retVal = (XAD)this.getTypedField(11, rep);
        return retVal;
    }

    public XAD getStf11_OfficeHomeAddress(int rep) {
        XAD retVal = (XAD)this.getTypedField(11, rep);
        return retVal;
    }

    public int getStf11_OfficeHomeAddressReps() {
        return this.getReps(11);
    }

    public XAD insertOfficeHomeAddress(int rep) throws HL7Exception {
        return (XAD)super.insertRepetition(11, rep);
    }

    public XAD insertStf11_OfficeHomeAddress(int rep) throws HL7Exception {
        return (XAD)super.insertRepetition(11, rep);
    }

    public XAD removeOfficeHomeAddress(int rep) throws HL7Exception {
        return (XAD)super.removeRepetition(11, rep);
    }

    public XAD removeStf11_OfficeHomeAddress(int rep) throws HL7Exception {
        return (XAD)super.removeRepetition(11, rep);
    }

    public DIN[] getInstitutionActivationDate() {
        DIN[] retVal = (DIN[])this.getTypedField(12, (Type[])new DIN[0]);
        return retVal;
    }

    public DIN[] getStf12_InstitutionActivationDate() {
        DIN[] retVal = (DIN[])this.getTypedField(12, (Type[])new DIN[0]);
        return retVal;
    }

    public int getInstitutionActivationDateReps() {
        return this.getReps(12);
    }

    public DIN getInstitutionActivationDate(int rep) {
        DIN retVal = (DIN)this.getTypedField(12, rep);
        return retVal;
    }

    public DIN getStf12_InstitutionActivationDate(int rep) {
        DIN retVal = (DIN)this.getTypedField(12, rep);
        return retVal;
    }

    public int getStf12_InstitutionActivationDateReps() {
        return this.getReps(12);
    }

    public DIN insertInstitutionActivationDate(int rep) throws HL7Exception {
        return (DIN)super.insertRepetition(12, rep);
    }

    public DIN insertStf12_InstitutionActivationDate(int rep) throws HL7Exception {
        return (DIN)super.insertRepetition(12, rep);
    }

    public DIN removeInstitutionActivationDate(int rep) throws HL7Exception {
        return (DIN)super.removeRepetition(12, rep);
    }

    public DIN removeStf12_InstitutionActivationDate(int rep) throws HL7Exception {
        return (DIN)super.removeRepetition(12, rep);
    }

    public DIN[] getInstitutionInactivationDate() {
        DIN[] retVal = (DIN[])this.getTypedField(13, (Type[])new DIN[0]);
        return retVal;
    }

    public DIN[] getStf13_InstitutionInactivationDate() {
        DIN[] retVal = (DIN[])this.getTypedField(13, (Type[])new DIN[0]);
        return retVal;
    }

    public int getInstitutionInactivationDateReps() {
        return this.getReps(13);
    }

    public DIN getInstitutionInactivationDate(int rep) {
        DIN retVal = (DIN)this.getTypedField(13, rep);
        return retVal;
    }

    public DIN getStf13_InstitutionInactivationDate(int rep) {
        DIN retVal = (DIN)this.getTypedField(13, rep);
        return retVal;
    }

    public int getStf13_InstitutionInactivationDateReps() {
        return this.getReps(13);
    }

    public DIN insertInstitutionInactivationDate(int rep) throws HL7Exception {
        return (DIN)super.insertRepetition(13, rep);
    }

    public DIN insertStf13_InstitutionInactivationDate(int rep) throws HL7Exception {
        return (DIN)super.insertRepetition(13, rep);
    }

    public DIN removeInstitutionInactivationDate(int rep) throws HL7Exception {
        return (DIN)super.removeRepetition(13, rep);
    }

    public DIN removeStf13_InstitutionInactivationDate(int rep) throws HL7Exception {
        return (DIN)super.removeRepetition(13, rep);
    }

    public CE[] getBackupPersonID() {
        CE[] retVal = (CE[])this.getTypedField(14, (Type[])new CE[0]);
        return retVal;
    }

    public CE[] getStf14_BackupPersonID() {
        CE[] retVal = (CE[])this.getTypedField(14, (Type[])new CE[0]);
        return retVal;
    }

    public int getBackupPersonIDReps() {
        return this.getReps(14);
    }

    public CE getBackupPersonID(int rep) {
        CE retVal = (CE)this.getTypedField(14, rep);
        return retVal;
    }

    public CE getStf14_BackupPersonID(int rep) {
        CE retVal = (CE)this.getTypedField(14, rep);
        return retVal;
    }

    public int getStf14_BackupPersonIDReps() {
        return this.getReps(14);
    }

    public CE insertBackupPersonID(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(14, rep);
    }

    public CE insertStf14_BackupPersonID(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(14, rep);
    }

    public CE removeBackupPersonID(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(14, rep);
    }

    public CE removeStf14_BackupPersonID(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(14, rep);
    }

    public ST[] getEMailAddress() {
        ST[] retVal = (ST[])this.getTypedField(15, (Type[])new ST[0]);
        return retVal;
    }

    public ST[] getStf15_EMailAddress() {
        ST[] retVal = (ST[])this.getTypedField(15, (Type[])new ST[0]);
        return retVal;
    }

    public int getEMailAddressReps() {
        return this.getReps(15);
    }

    public ST getEMailAddress(int rep) {
        ST retVal = (ST)this.getTypedField(15, rep);
        return retVal;
    }

    public ST getStf15_EMailAddress(int rep) {
        ST retVal = (ST)this.getTypedField(15, rep);
        return retVal;
    }

    public int getStf15_EMailAddressReps() {
        return this.getReps(15);
    }

    public ST insertEMailAddress(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(15, rep);
    }

    public ST insertStf15_EMailAddress(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(15, rep);
    }

    public ST removeEMailAddress(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(15, rep);
    }

    public ST removeStf15_EMailAddress(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(15, rep);
    }

    public CE getPreferredMethodOfContact() {
        CE retVal = (CE)this.getTypedField(16, 0);
        return retVal;
    }

    public CE getStf16_PreferredMethodOfContact() {
        CE retVal = (CE)this.getTypedField(16, 0);
        return retVal;
    }

    public CE getMaritalStatus() {
        CE retVal = (CE)this.getTypedField(17, 0);
        return retVal;
    }

    public CE getStf17_MaritalStatus() {
        CE retVal = (CE)this.getTypedField(17, 0);
        return retVal;
    }

    public ST getJobTitle() {
        ST retVal = (ST)this.getTypedField(18, 0);
        return retVal;
    }

    public ST getStf18_JobTitle() {
        ST retVal = (ST)this.getTypedField(18, 0);
        return retVal;
    }

    public JCC getJobCodeClass() {
        JCC retVal = (JCC)this.getTypedField(19, 0);
        return retVal;
    }

    public JCC getStf19_JobCodeClass() {
        JCC retVal = (JCC)this.getTypedField(19, 0);
        return retVal;
    }

    public IS getEmploymentStatus() {
        IS retVal = (IS)this.getTypedField(20, 0);
        return retVal;
    }

    public IS getStf20_EmploymentStatus() {
        IS retVal = (IS)this.getTypedField(20, 0);
        return retVal;
    }

    public ID getAdditionalInsuredOnAuto() {
        ID retVal = (ID)this.getTypedField(21, 0);
        return retVal;
    }

    public ID getStf21_AdditionalInsuredOnAuto() {
        ID retVal = (ID)this.getTypedField(21, 0);
        return retVal;
    }

    public DLN getDriverSLicenseNumberStaff() {
        DLN retVal = (DLN)this.getTypedField(22, 0);
        return retVal;
    }

    public DLN getStf22_DriverSLicenseNumberStaff() {
        DLN retVal = (DLN)this.getTypedField(22, 0);
        return retVal;
    }

    public ID getCopyAutoIns() {
        ID retVal = (ID)this.getTypedField(23, 0);
        return retVal;
    }

    public ID getStf23_CopyAutoIns() {
        ID retVal = (ID)this.getTypedField(23, 0);
        return retVal;
    }

    public DT getAutoInsExpires() {
        DT retVal = (DT)this.getTypedField(24, 0);
        return retVal;
    }

    public DT getStf24_AutoInsExpires() {
        DT retVal = (DT)this.getTypedField(24, 0);
        return retVal;
    }

    public DT getDateLastDMVReview() {
        DT retVal = (DT)this.getTypedField(25, 0);
        return retVal;
    }

    public DT getStf25_DateLastDMVReview() {
        DT retVal = (DT)this.getTypedField(25, 0);
        return retVal;
    }

    public DT getDateNextDMVReview() {
        DT retVal = (DT)this.getTypedField(26, 0);
        return retVal;
    }

    public DT getStf26_DateNextDMVReview() {
        DT retVal = (DT)this.getTypedField(26, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new CE(this.getMessage());
            }
            case 1: {
                return new CX(this.getMessage());
            }
            case 2: {
                return new XPN(this.getMessage());
            }
            case 3: {
                return new IS(this.getMessage(), new Integer(182));
            }
            case 4: {
                return new IS(this.getMessage(), new Integer(1));
            }
            case 5: {
                return new TS(this.getMessage());
            }
            case 6: {
                return new ID(this.getMessage(), new Integer(183));
            }
            case 7: {
                return new CE(this.getMessage());
            }
            case 8: {
                return new CE(this.getMessage());
            }
            case 9: {
                return new XTN(this.getMessage());
            }
            case 10: {
                return new XAD(this.getMessage());
            }
            case 11: {
                return new DIN(this.getMessage());
            }
            case 12: {
                return new DIN(this.getMessage());
            }
            case 13: {
                return new CE(this.getMessage());
            }
            case 14: {
                return new ST(this.getMessage());
            }
            case 15: {
                return new CE(this.getMessage());
            }
            case 16: {
                return new CE(this.getMessage());
            }
            case 17: {
                return new ST(this.getMessage());
            }
            case 18: {
                return new JCC(this.getMessage());
            }
            case 19: {
                return new IS(this.getMessage(), new Integer(66));
            }
            case 20: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 21: {
                return new DLN(this.getMessage());
            }
            case 22: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 23: {
                return new DT(this.getMessage());
            }
            case 24: {
                return new DT(this.getMessage());
            }
            case 25: {
                return new DT(this.getMessage());
            }
        }
        return null;
    }
}

