/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v24.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v24.datatype.CE;
import ca.uhn.hl7v2.model.v24.datatype.ID;
import ca.uhn.hl7v2.model.v24.datatype.NM;
import ca.uhn.hl7v2.model.v24.datatype.ST;
import ca.uhn.hl7v2.model.v24.datatype.TQ;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class ECD
extends AbstractSegment {
    public ECD(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(NM.class, true, 1, 20, new Object[]{this.getMessage()}, "Reference Command Number");
            this.add(CE.class, true, 1, 250, new Object[]{this.getMessage()}, "Remote Control Command");
            this.add(ID.class, false, 1, 80, new Object[]{this.getMessage(), new Integer(136)}, "Response Required");
            this.add(TQ.class, false, 1, 200, new Object[]{this.getMessage()}, "Requested Completion Time");
            this.add(ST.class, false, 0, 65536, new Object[]{this.getMessage()}, "Parameters");
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating ECD - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public NM getReferenceCommandNumber() {
        NM retVal = (NM)this.getTypedField(1, 0);
        return retVal;
    }

    public NM getEcd1_ReferenceCommandNumber() {
        NM retVal = (NM)this.getTypedField(1, 0);
        return retVal;
    }

    public CE getRemoteControlCommand() {
        CE retVal = (CE)this.getTypedField(2, 0);
        return retVal;
    }

    public CE getEcd2_RemoteControlCommand() {
        CE retVal = (CE)this.getTypedField(2, 0);
        return retVal;
    }

    public ID getResponseRequired() {
        ID retVal = (ID)this.getTypedField(3, 0);
        return retVal;
    }

    public ID getEcd3_ResponseRequired() {
        ID retVal = (ID)this.getTypedField(3, 0);
        return retVal;
    }

    public TQ getRequestedCompletionTime() {
        TQ retVal = (TQ)this.getTypedField(4, 0);
        return retVal;
    }

    public TQ getEcd4_RequestedCompletionTime() {
        TQ retVal = (TQ)this.getTypedField(4, 0);
        return retVal;
    }

    public ST[] getParameters() {
        ST[] retVal = (ST[])this.getTypedField(5, (Type[])new ST[0]);
        return retVal;
    }

    public ST[] getEcd5_Parameters() {
        ST[] retVal = (ST[])this.getTypedField(5, (Type[])new ST[0]);
        return retVal;
    }

    public int getParametersReps() {
        return this.getReps(5);
    }

    public ST getParameters(int rep) {
        ST retVal = (ST)this.getTypedField(5, rep);
        return retVal;
    }

    public ST getEcd5_Parameters(int rep) {
        ST retVal = (ST)this.getTypedField(5, rep);
        return retVal;
    }

    public int getEcd5_ParametersReps() {
        return this.getReps(5);
    }

    public ST insertParameters(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(5, rep);
    }

    public ST insertEcd5_Parameters(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(5, rep);
    }

    public ST removeParameters(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(5, rep);
    }

    public ST removeEcd5_Parameters(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(5, rep);
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new NM(this.getMessage());
            }
            case 1: {
                return new CE(this.getMessage());
            }
            case 2: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 3: {
                return new TQ(this.getMessage());
            }
            case 4: {
                return new ST(this.getMessage());
            }
        }
        return null;
    }
}

