/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.connector;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class CustomSchedulingConfigurationOverrides
implements JsonpSerializable {
    @Nullable
    private final Integer maxCrawlDepth;
    @Nullable
    private final Boolean sitemapDiscoveryDisabled;
    private final List<String> domainAllowlist;
    private final List<String> sitemapUrls;
    private final List<String> seedUrls;
    public static final JsonpDeserializer<CustomSchedulingConfigurationOverrides> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CustomSchedulingConfigurationOverrides::setupCustomSchedulingConfigurationOverridesDeserializer);

    private CustomSchedulingConfigurationOverrides(Builder builder) {
        this.maxCrawlDepth = builder.maxCrawlDepth;
        this.sitemapDiscoveryDisabled = builder.sitemapDiscoveryDisabled;
        this.domainAllowlist = ApiTypeHelper.unmodifiable(builder.domainAllowlist);
        this.sitemapUrls = ApiTypeHelper.unmodifiable(builder.sitemapUrls);
        this.seedUrls = ApiTypeHelper.unmodifiable(builder.seedUrls);
    }

    public static CustomSchedulingConfigurationOverrides of(Function<Builder, ObjectBuilder<CustomSchedulingConfigurationOverrides>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Integer maxCrawlDepth() {
        return this.maxCrawlDepth;
    }

    @Nullable
    public final Boolean sitemapDiscoveryDisabled() {
        return this.sitemapDiscoveryDisabled;
    }

    public final List<String> domainAllowlist() {
        return this.domainAllowlist;
    }

    public final List<String> sitemapUrls() {
        return this.sitemapUrls;
    }

    public final List<String> seedUrls() {
        return this.seedUrls;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.maxCrawlDepth != null) {
            generator.writeKey("max_crawl_depth");
            generator.write(this.maxCrawlDepth.intValue());
        }
        if (this.sitemapDiscoveryDisabled != null) {
            generator.writeKey("sitemap_discovery_disabled");
            generator.write(this.sitemapDiscoveryDisabled.booleanValue());
        }
        if (ApiTypeHelper.isDefined(this.domainAllowlist)) {
            generator.writeKey("domain_allowlist");
            generator.writeStartArray();
            for (String item0 : this.domainAllowlist) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.sitemapUrls)) {
            generator.writeKey("sitemap_urls");
            generator.writeStartArray();
            for (String item0 : this.sitemapUrls) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.seedUrls)) {
            generator.writeKey("seed_urls");
            generator.writeStartArray();
            for (String item0 : this.seedUrls) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupCustomSchedulingConfigurationOverridesDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::maxCrawlDepth, JsonpDeserializer.integerDeserializer(), "max_crawl_depth");
        op.add(Builder::sitemapDiscoveryDisabled, JsonpDeserializer.booleanDeserializer(), "sitemap_discovery_disabled");
        op.add(Builder::domainAllowlist, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "domain_allowlist");
        op.add(Builder::sitemapUrls, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "sitemap_urls");
        op.add(Builder::seedUrls, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "seed_urls");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<CustomSchedulingConfigurationOverrides> {
        @Nullable
        private Integer maxCrawlDepth;
        @Nullable
        private Boolean sitemapDiscoveryDisabled;
        @Nullable
        private List<String> domainAllowlist;
        @Nullable
        private List<String> sitemapUrls;
        @Nullable
        private List<String> seedUrls;

        public final Builder maxCrawlDepth(@Nullable Integer value) {
            this.maxCrawlDepth = value;
            return this;
        }

        public final Builder sitemapDiscoveryDisabled(@Nullable Boolean value) {
            this.sitemapDiscoveryDisabled = value;
            return this;
        }

        public final Builder domainAllowlist(List<String> list) {
            this.domainAllowlist = Builder._listAddAll(this.domainAllowlist, list);
            return this;
        }

        public final Builder domainAllowlist(String value, String ... values) {
            this.domainAllowlist = Builder._listAdd(this.domainAllowlist, value, values);
            return this;
        }

        public final Builder sitemapUrls(List<String> list) {
            this.sitemapUrls = Builder._listAddAll(this.sitemapUrls, list);
            return this;
        }

        public final Builder sitemapUrls(String value, String ... values) {
            this.sitemapUrls = Builder._listAdd(this.sitemapUrls, value, values);
            return this;
        }

        public final Builder seedUrls(List<String> list) {
            this.seedUrls = Builder._listAddAll(this.seedUrls, list);
            return this;
        }

        public final Builder seedUrls(String value, String ... values) {
            this.seedUrls = Builder._listAdd(this.seedUrls, value, values);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public CustomSchedulingConfigurationOverrides build() {
            this._checkSingleUse();
            return new CustomSchedulingConfigurationOverrides(this);
        }
    }
}

