/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.elasticsearch._types.ScriptLanguage;
import co.elastic.clients.elasticsearch._types.ScriptSource;
import co.elastic.clients.elasticsearch._types.query_dsl.IntervalsFilter;
import co.elastic.clients.elasticsearch._types.query_dsl.IntervalsFilterVariant;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class Script
implements IntervalsFilterVariant,
JsonpSerializable {
    @Nullable
    private final ScriptSource source;
    @Nullable
    private final String id;
    private final Map<String, JsonData> params;
    @Nullable
    private final String lang;
    private final Map<String, String> options;
    public static final JsonpDeserializer<Script> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Script::setupScriptDeserializer);

    private Script(Builder builder) {
        this.source = builder.source;
        this.id = builder.id;
        this.params = ApiTypeHelper.unmodifiable(builder.params);
        this.lang = builder.lang;
        this.options = ApiTypeHelper.unmodifiable(builder.options);
    }

    public static Script of(Function<Builder, ObjectBuilder<Script>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public IntervalsFilter.Kind _intervalsFilterKind() {
        return IntervalsFilter.Kind.Script;
    }

    @Nullable
    public final ScriptSource source() {
        return this.source;
    }

    @Nullable
    public final String id() {
        return this.id;
    }

    public final Map<String, JsonData> params() {
        return this.params;
    }

    @Nullable
    public final String lang() {
        return this.lang;
    }

    public final Map<String, String> options() {
        return this.options;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.source != null) {
            generator.writeKey("source");
            this.source.serialize(generator, mapper);
        }
        if (this.id != null) {
            generator.writeKey("id");
            generator.write(this.id);
        }
        if (ApiTypeHelper.isDefined(this.params)) {
            generator.writeKey("params");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> entry : this.params.entrySet()) {
                generator.writeKey(entry.getKey());
                entry.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.lang != null) {
            generator.writeKey("lang");
            generator.write(this.lang);
        }
        if (ApiTypeHelper.isDefined(this.options)) {
            generator.writeKey("options");
            generator.writeStartObject();
            for (Map.Entry<String, Object> entry : this.options.entrySet()) {
                generator.writeKey(entry.getKey());
                generator.write((String)entry.getValue());
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupScriptDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::source, ScriptSource._DESERIALIZER, "source");
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "id");
        op.add(Builder::params, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "params");
        op.add(Builder::lang, JsonpDeserializer.stringDeserializer(), "lang");
        op.add(Builder::options, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "options");
        op.shortcutProperty("source");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<Script> {
        @Nullable
        private ScriptSource source;
        @Nullable
        private String id;
        @Nullable
        private Map<String, JsonData> params;
        @Nullable
        private String lang;
        @Nullable
        private Map<String, String> options;

        public final Builder source(@Nullable ScriptSource value) {
            this.source = value;
            return this;
        }

        public final Builder source(Function<ScriptSource.Builder, ObjectBuilder<ScriptSource>> fn) {
            return this.source(fn.apply(new ScriptSource.Builder()).build());
        }

        public final Builder id(@Nullable String value) {
            this.id = value;
            return this;
        }

        public final Builder params(Map<String, JsonData> map) {
            this.params = Builder._mapPutAll(this.params, map);
            return this;
        }

        public final Builder params(String key, JsonData value) {
            this.params = Builder._mapPut(this.params, key, value);
            return this;
        }

        public final Builder lang(@Nullable String value) {
            this.lang = value;
            return this;
        }

        public final Builder lang(@Nullable ScriptLanguage value) {
            this.lang = value == null ? null : value.jsonValue();
            return this;
        }

        public final Builder options(Map<String, String> map) {
            this.options = Builder._mapPutAll(this.options, map);
            return this;
        }

        public final Builder options(String key, String value) {
            this.options = Builder._mapPut(this.options, key, value);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Script build() {
            this._checkSingleUse();
            return new Script(this);
        }
    }
}

