/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.CharFilterDefinitionVariant;
import co.elastic.clients.elasticsearch._types.analysis.HtmlStripCharFilter;
import co.elastic.clients.elasticsearch._types.analysis.IcuNormalizationCharFilter;
import co.elastic.clients.elasticsearch._types.analysis.KuromojiIterationMarkCharFilter;
import co.elastic.clients.elasticsearch._types.analysis.MappingCharFilter;
import co.elastic.clients.elasticsearch._types.analysis.PatternReplaceCharFilter;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonEnum;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.OpenTaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class CharFilterDefinition
implements OpenTaggedUnion<Kind, Object>,
JsonpSerializable {
    private final Kind _kind;
    private final Object _value;
    @Nullable
    private final String _customKind;
    public static final JsonpDeserializer<CharFilterDefinition> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CharFilterDefinition::setupCharFilterDefinitionDeserializer, Builder::build);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    public CharFilterDefinition(CharFilterDefinitionVariant value) {
        this._kind = ApiTypeHelper.requireNonNull(value._charFilterDefinitionKind(), this, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(value, this, "<variant value>");
        this._customKind = null;
    }

    private CharFilterDefinition(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
        this._customKind = builder._customKind;
    }

    public static CharFilterDefinition of(Function<Builder, ObjectBuilder<CharFilterDefinition>> fn) {
        return fn.apply(new Builder()).build();
    }

    public CharFilterDefinition(String kind, JsonData value) {
        this._kind = Kind._Custom;
        this._value = value;
        this._customKind = kind;
    }

    public boolean isHtmlStrip() {
        return this._kind == Kind.HtmlStrip;
    }

    public HtmlStripCharFilter htmlStrip() {
        return (HtmlStripCharFilter)TaggedUnionUtils.get(this, Kind.HtmlStrip);
    }

    public boolean isIcuNormalizer() {
        return this._kind == Kind.IcuNormalizer;
    }

    public IcuNormalizationCharFilter icuNormalizer() {
        return (IcuNormalizationCharFilter)TaggedUnionUtils.get(this, Kind.IcuNormalizer);
    }

    public boolean isKuromojiIterationMark() {
        return this._kind == Kind.KuromojiIterationMark;
    }

    public KuromojiIterationMarkCharFilter kuromojiIterationMark() {
        return (KuromojiIterationMarkCharFilter)TaggedUnionUtils.get(this, Kind.KuromojiIterationMark);
    }

    public boolean isMapping() {
        return this._kind == Kind.Mapping;
    }

    public MappingCharFilter mapping() {
        return (MappingCharFilter)TaggedUnionUtils.get(this, Kind.Mapping);
    }

    public boolean isPatternReplace() {
        return this._kind == Kind.PatternReplace;
    }

    public PatternReplaceCharFilter patternReplace() {
        return (PatternReplaceCharFilter)TaggedUnionUtils.get(this, Kind.PatternReplace);
    }

    public boolean _isCustom() {
        return this._kind == Kind._Custom;
    }

    @Override
    @Nullable
    public final String _customKind() {
        return this._customKind;
    }

    public JsonData _custom() {
        return (JsonData)TaggedUnionUtils.get(this, Kind._Custom);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        mapper.serialize(this._value, generator);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupCharFilterDefinitionDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::htmlStrip, HtmlStripCharFilter._DESERIALIZER, "html_strip");
        op.add(Builder::icuNormalizer, IcuNormalizationCharFilter._DESERIALIZER, "icu_normalizer");
        op.add(Builder::kuromojiIterationMark, KuromojiIterationMarkCharFilter._DESERIALIZER, "kuromoji_iteration_mark");
        op.add(Builder::mapping, MappingCharFilter._DESERIALIZER, "mapping");
        op.add(Builder::patternReplace, PatternReplaceCharFilter._DESERIALIZER, "pattern_replace");
        op.setUnknownFieldHandler((builder, name, parser, mapper) -> {
            JsonpUtils.ensureCustomVariantsAllowed(parser, mapper);
            builder._custom((String)name, JsonData._DESERIALIZER.deserialize((JsonParser)parser, (JsonpMapper)mapper));
        });
        op.setTypeProperty("type", null);
    }

    public static enum Kind implements JsonEnum
    {
        HtmlStrip("html_strip"),
        IcuNormalizer("icu_normalizer"),
        KuromojiIterationMark("kuromoji_iteration_mark"),
        Mapping("mapping"),
        PatternReplace("pattern_replace"),
        _Custom(null);

        private final String jsonValue;

        private Kind(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        @Override
        public String jsonValue() {
            return this.jsonValue;
        }
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<CharFilterDefinition> {
        private Kind _kind;
        private Object _value;
        private String _customKind;

        @Override
        protected Builder self() {
            return this;
        }

        public ObjectBuilder<CharFilterDefinition> htmlStrip(HtmlStripCharFilter v) {
            this._kind = Kind.HtmlStrip;
            this._value = v;
            return this;
        }

        public ObjectBuilder<CharFilterDefinition> htmlStrip(Function<HtmlStripCharFilter.Builder, ObjectBuilder<HtmlStripCharFilter>> fn) {
            return this.htmlStrip(fn.apply(new HtmlStripCharFilter.Builder()).build());
        }

        public ObjectBuilder<CharFilterDefinition> icuNormalizer(IcuNormalizationCharFilter v) {
            this._kind = Kind.IcuNormalizer;
            this._value = v;
            return this;
        }

        public ObjectBuilder<CharFilterDefinition> icuNormalizer(Function<IcuNormalizationCharFilter.Builder, ObjectBuilder<IcuNormalizationCharFilter>> fn) {
            return this.icuNormalizer(fn.apply(new IcuNormalizationCharFilter.Builder()).build());
        }

        public ObjectBuilder<CharFilterDefinition> kuromojiIterationMark(KuromojiIterationMarkCharFilter v) {
            this._kind = Kind.KuromojiIterationMark;
            this._value = v;
            return this;
        }

        public ObjectBuilder<CharFilterDefinition> kuromojiIterationMark(Function<KuromojiIterationMarkCharFilter.Builder, ObjectBuilder<KuromojiIterationMarkCharFilter>> fn) {
            return this.kuromojiIterationMark(fn.apply(new KuromojiIterationMarkCharFilter.Builder()).build());
        }

        public ObjectBuilder<CharFilterDefinition> mapping(MappingCharFilter v) {
            this._kind = Kind.Mapping;
            this._value = v;
            return this;
        }

        public ObjectBuilder<CharFilterDefinition> mapping(Function<MappingCharFilter.Builder, ObjectBuilder<MappingCharFilter>> fn) {
            return this.mapping(fn.apply(new MappingCharFilter.Builder()).build());
        }

        public ObjectBuilder<CharFilterDefinition> patternReplace(PatternReplaceCharFilter v) {
            this._kind = Kind.PatternReplace;
            this._value = v;
            return this;
        }

        public ObjectBuilder<CharFilterDefinition> patternReplace(Function<PatternReplaceCharFilter.Builder, ObjectBuilder<PatternReplaceCharFilter>> fn) {
            return this.patternReplace(fn.apply(new PatternReplaceCharFilter.Builder()).build());
        }

        public ObjectBuilder<CharFilterDefinition> _custom(String name, Object data) {
            this._kind = Kind._Custom;
            this._customKind = name;
            this._value = JsonData.of(data);
            return this;
        }

        @Override
        public CharFilterDefinition build() {
            this._checkSingleUse();
            return new CharFilterDefinition(this);
        }
    }
}

