/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.connector;

import co.elastic.clients.elasticsearch.connector.FeatureEnabled;
import co.elastic.clients.elasticsearch.connector.SyncRulesFeature;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ConnectorFeatures
implements JsonpSerializable {
    @Nullable
    private final FeatureEnabled documentLevelSecurity;
    @Nullable
    private final FeatureEnabled incrementalSync;
    @Nullable
    private final FeatureEnabled nativeConnectorApiKeys;
    @Nullable
    private final SyncRulesFeature syncRules;
    public static final JsonpDeserializer<ConnectorFeatures> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ConnectorFeatures::setupConnectorFeaturesDeserializer);

    private ConnectorFeatures(Builder builder) {
        this.documentLevelSecurity = builder.documentLevelSecurity;
        this.incrementalSync = builder.incrementalSync;
        this.nativeConnectorApiKeys = builder.nativeConnectorApiKeys;
        this.syncRules = builder.syncRules;
    }

    public static ConnectorFeatures of(Function<Builder, ObjectBuilder<ConnectorFeatures>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final FeatureEnabled documentLevelSecurity() {
        return this.documentLevelSecurity;
    }

    @Nullable
    public final FeatureEnabled incrementalSync() {
        return this.incrementalSync;
    }

    @Nullable
    public final FeatureEnabled nativeConnectorApiKeys() {
        return this.nativeConnectorApiKeys;
    }

    @Nullable
    public final SyncRulesFeature syncRules() {
        return this.syncRules;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.documentLevelSecurity != null) {
            generator.writeKey("document_level_security");
            this.documentLevelSecurity.serialize(generator, mapper);
        }
        if (this.incrementalSync != null) {
            generator.writeKey("incremental_sync");
            this.incrementalSync.serialize(generator, mapper);
        }
        if (this.nativeConnectorApiKeys != null) {
            generator.writeKey("native_connector_api_keys");
            this.nativeConnectorApiKeys.serialize(generator, mapper);
        }
        if (this.syncRules != null) {
            generator.writeKey("sync_rules");
            this.syncRules.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupConnectorFeaturesDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::documentLevelSecurity, FeatureEnabled._DESERIALIZER, "document_level_security");
        op.add(Builder::incrementalSync, FeatureEnabled._DESERIALIZER, "incremental_sync");
        op.add(Builder::nativeConnectorApiKeys, FeatureEnabled._DESERIALIZER, "native_connector_api_keys");
        op.add(Builder::syncRules, SyncRulesFeature._DESERIALIZER, "sync_rules");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ConnectorFeatures> {
        @Nullable
        private FeatureEnabled documentLevelSecurity;
        @Nullable
        private FeatureEnabled incrementalSync;
        @Nullable
        private FeatureEnabled nativeConnectorApiKeys;
        @Nullable
        private SyncRulesFeature syncRules;

        public final Builder documentLevelSecurity(@Nullable FeatureEnabled value) {
            this.documentLevelSecurity = value;
            return this;
        }

        public final Builder documentLevelSecurity(Function<FeatureEnabled.Builder, ObjectBuilder<FeatureEnabled>> fn) {
            return this.documentLevelSecurity(fn.apply(new FeatureEnabled.Builder()).build());
        }

        public final Builder incrementalSync(@Nullable FeatureEnabled value) {
            this.incrementalSync = value;
            return this;
        }

        public final Builder incrementalSync(Function<FeatureEnabled.Builder, ObjectBuilder<FeatureEnabled>> fn) {
            return this.incrementalSync(fn.apply(new FeatureEnabled.Builder()).build());
        }

        public final Builder nativeConnectorApiKeys(@Nullable FeatureEnabled value) {
            this.nativeConnectorApiKeys = value;
            return this;
        }

        public final Builder nativeConnectorApiKeys(Function<FeatureEnabled.Builder, ObjectBuilder<FeatureEnabled>> fn) {
            return this.nativeConnectorApiKeys(fn.apply(new FeatureEnabled.Builder()).build());
        }

        public final Builder syncRules(@Nullable SyncRulesFeature value) {
            this.syncRules = value;
            return this;
        }

        public final Builder syncRules(Function<SyncRulesFeature.Builder, ObjectBuilder<SyncRulesFeature>> fn) {
            return this.syncRules(fn.apply(new SyncRulesFeature.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ConnectorFeatures build() {
            this._checkSingleUse();
            return new ConnectorFeatures(this);
        }
    }
}

