/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.Refresh;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch._types.VersionType;
import co.elastic.clients.elasticsearch._types.WaitForActiveShards;
import co.elastic.clients.elasticsearch.core.CreateResponse;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpSerializer;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.NamedDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class CreateRequest<TDocument>
extends RequestBase
implements JsonpSerializable {
    private final String id;
    @Nullable
    private final Boolean includeSourceOnError;
    private final String index;
    @Nullable
    private final String pipeline;
    @Nullable
    private final Refresh refresh;
    @Nullable
    private final Boolean requireAlias;
    @Nullable
    private final Boolean requireDataStream;
    @Nullable
    private final String routing;
    @Nullable
    private final Time timeout;
    @Nullable
    private final Long version;
    @Nullable
    private final VersionType versionType;
    @Nullable
    private final WaitForActiveShards waitForActiveShards;
    private final TDocument document;
    @Nullable
    private final JsonpSerializer<TDocument> tDocumentSerializer;
    public static final JsonpDeserializer<CreateRequest<Object>> _DESERIALIZER = CreateRequest.createCreateRequestDeserializer(new NamedDeserializer("co.elastic.clients:Deserializer:_global.create.Request.TDocument"));
    public static final Endpoint<CreateRequest<?>, CreateResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<CreateRequest, CreateResponse>("es/create", request -> "PUT", request -> {
        boolean _index = true;
        int _id = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index, buf);
            buf.append("/_create");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.id, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _index = true;
        int _id = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            params.put("index", request.index);
            params.put("id", request.id);
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.pipeline != null) {
            params.put("pipeline", request.pipeline);
        }
        if (request.routing != null) {
            params.put("routing", request.routing);
        }
        if (request.includeSourceOnError != null) {
            params.put("include_source_on_error", String.valueOf(request.includeSourceOnError));
        }
        if (request.requireAlias != null) {
            params.put("require_alias", String.valueOf(request.requireAlias));
        }
        if (request.versionType != null) {
            params.put("version_type", request.versionType.jsonValue());
        }
        if (request.refresh != null) {
            params.put("refresh", request.refresh.jsonValue());
        }
        if (request.waitForActiveShards != null) {
            params.put("wait_for_active_shards", request.waitForActiveShards._toJsonString());
        }
        if (request.requireDataStream != null) {
            params.put("require_data_stream", String.valueOf(request.requireDataStream));
        }
        if (request.version != null) {
            params.put("version", String.valueOf(request.version));
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout._toJsonString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), r -> r.document(), CreateResponse._DESERIALIZER);

    private CreateRequest(Builder<TDocument> builder) {
        this.id = ApiTypeHelper.requireNonNull(builder.id, this, "id");
        this.includeSourceOnError = builder.includeSourceOnError;
        this.index = ApiTypeHelper.requireNonNull(builder.index, this, "index");
        this.pipeline = builder.pipeline;
        this.refresh = builder.refresh;
        this.requireAlias = builder.requireAlias;
        this.requireDataStream = builder.requireDataStream;
        this.routing = builder.routing;
        this.timeout = builder.timeout;
        this.version = builder.version;
        this.versionType = builder.versionType;
        this.waitForActiveShards = builder.waitForActiveShards;
        this.document = ApiTypeHelper.requireNonNull(builder.document, this, "document");
        this.tDocumentSerializer = builder.tDocumentSerializer;
    }

    public static <TDocument> CreateRequest<TDocument> of(Function<Builder<TDocument>, ObjectBuilder<CreateRequest<TDocument>>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String id() {
        return this.id;
    }

    @Nullable
    public final Boolean includeSourceOnError() {
        return this.includeSourceOnError;
    }

    public final String index() {
        return this.index;
    }

    @Nullable
    public final String pipeline() {
        return this.pipeline;
    }

    @Nullable
    public final Refresh refresh() {
        return this.refresh;
    }

    @Nullable
    public final Boolean requireAlias() {
        return this.requireAlias;
    }

    @Nullable
    public final Boolean requireDataStream() {
        return this.requireDataStream;
    }

    @Nullable
    public final String routing() {
        return this.routing;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    @Nullable
    public final Long version() {
        return this.version;
    }

    @Nullable
    public final VersionType versionType() {
        return this.versionType;
    }

    @Nullable
    public final WaitForActiveShards waitForActiveShards() {
        return this.waitForActiveShards;
    }

    public final TDocument document() {
        return this.document;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        JsonpUtils.serialize(this.document, generator, this.tDocumentSerializer, mapper);
    }

    public static <TDocument> JsonpDeserializer<CreateRequest<TDocument>> createCreateRequestDeserializer(JsonpDeserializer<TDocument> tDocumentDeserializer) {
        JsonpDeserializer valueDeserializer = tDocumentDeserializer;
        return JsonpDeserializer.of(valueDeserializer.acceptedEvents(), (parser, mapper, event) -> new Builder().document(valueDeserializer.deserialize((JsonParser)parser, (JsonpMapper)mapper, (JsonParser.Event)event)).build());
    }

    public static class Builder<TDocument>
    extends RequestBase.AbstractBuilder<Builder<TDocument>>
    implements ObjectBuilder<CreateRequest<TDocument>> {
        private String id;
        @Nullable
        private Boolean includeSourceOnError;
        private String index;
        @Nullable
        private String pipeline;
        @Nullable
        private Refresh refresh;
        @Nullable
        private Boolean requireAlias;
        @Nullable
        private Boolean requireDataStream;
        @Nullable
        private String routing;
        @Nullable
        private Time timeout;
        @Nullable
        private Long version;
        @Nullable
        private VersionType versionType;
        @Nullable
        private WaitForActiveShards waitForActiveShards;
        private TDocument document;
        @Nullable
        private JsonpSerializer<TDocument> tDocumentSerializer;

        public final Builder<TDocument> id(String value) {
            this.id = value;
            return this;
        }

        public final Builder<TDocument> includeSourceOnError(@Nullable Boolean value) {
            this.includeSourceOnError = value;
            return this;
        }

        public final Builder<TDocument> index(String value) {
            this.index = value;
            return this;
        }

        public final Builder<TDocument> pipeline(@Nullable String value) {
            this.pipeline = value;
            return this;
        }

        public final Builder<TDocument> refresh(@Nullable Refresh value) {
            this.refresh = value;
            return this;
        }

        public final Builder<TDocument> requireAlias(@Nullable Boolean value) {
            this.requireAlias = value;
            return this;
        }

        public final Builder<TDocument> requireDataStream(@Nullable Boolean value) {
            this.requireDataStream = value;
            return this;
        }

        public final Builder<TDocument> routing(@Nullable String value) {
            this.routing = value;
            return this;
        }

        public final Builder<TDocument> timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder<TDocument> timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder<TDocument> version(@Nullable Long value) {
            this.version = value;
            return this;
        }

        public final Builder<TDocument> versionType(@Nullable VersionType value) {
            this.versionType = value;
            return this;
        }

        public final Builder<TDocument> waitForActiveShards(@Nullable WaitForActiveShards value) {
            this.waitForActiveShards = value;
            return this;
        }

        public final Builder<TDocument> waitForActiveShards(Function<WaitForActiveShards.Builder, ObjectBuilder<WaitForActiveShards>> fn) {
            return this.waitForActiveShards(fn.apply(new WaitForActiveShards.Builder()).build());
        }

        public final Builder<TDocument> document(TDocument value) {
            this.document = value;
            return this;
        }

        public final Builder<TDocument> tDocumentSerializer(@Nullable JsonpSerializer<TDocument> value) {
            this.tDocumentSerializer = value;
            return this;
        }

        @Override
        public Builder<TDocument> withJson(JsonParser parser, JsonpMapper mapper) {
            JsonpDeserializer<JsonData> tDocumentDeserializer = JsonData._DESERIALIZER;
            JsonData value = tDocumentDeserializer.deserialize(parser, mapper);
            return this.document(value);
        }

        @Override
        protected Builder<TDocument> self() {
            return this;
        }

        @Override
        public CreateRequest<TDocument> build() {
            this._checkSingleUse();
            return new CreateRequest(this);
        }
    }
}

