/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.search;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.UnionDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

@JsonpDeserializable
public class SourceConfigParam
implements TaggedUnion<Kind, Object>,
JsonpSerializable {
    private final Kind _kind;
    private final Object _value;
    public static final JsonpDeserializer<SourceConfigParam> _DESERIALIZER = JsonpDeserializer.lazy(SourceConfigParam::buildSourceConfigParamDeserializer);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    private SourceConfigParam(Kind kind, Object value) {
        this._kind = kind;
        this._value = value;
    }

    public String _toJsonString() {
        switch (this._kind) {
            case Fields: {
                return this.fields().stream().map(v -> v).collect(Collectors.joining(","));
            }
            case Fetch: {
                return String.valueOf(this.fetch());
            }
        }
        throw new IllegalStateException("Unknown kind " + String.valueOf((Object)this._kind));
    }

    private SourceConfigParam(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static SourceConfigParam of(Function<Builder, ObjectBuilder<SourceConfigParam>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isFields() {
        return this._kind == Kind.Fields;
    }

    public List<String> fields() {
        return (List)TaggedUnionUtils.get(this, Kind.Fields);
    }

    public boolean isFetch() {
        return this._kind == Kind.Fetch;
    }

    public Boolean fetch() {
        return (Boolean)TaggedUnionUtils.get(this, Kind.Fetch);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        } else {
            switch (this._kind) {
                case Fields: {
                    generator.writeStartArray();
                    for (String item0 : (List)this._value) {
                        generator.write(item0);
                    }
                    generator.writeEnd();
                    break;
                }
                case Fetch: {
                    generator.write(((Boolean)this._value).booleanValue());
                }
            }
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    private static JsonpDeserializer<SourceConfigParam> buildSourceConfigParamDeserializer() {
        return new UnionDeserializer.Builder<SourceConfigParam, Kind, Object>(SourceConfigParam::new, false).addMember(Kind.Fields, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer())).addMember(Kind.Fetch, JsonpDeserializer.booleanDeserializer()).build();
    }

    public static enum Kind {
        Fields,
        Fetch;

    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<SourceConfigParam> {
        private Kind _kind;
        private Object _value;

        public ObjectBuilder<SourceConfigParam> fields(List<String> v) {
            this._kind = Kind.Fields;
            this._value = v;
            return this;
        }

        public ObjectBuilder<SourceConfigParam> fetch(Boolean v) {
            this._kind = Kind.Fetch;
            this._value = v;
            return this;
        }

        @Override
        public SourceConfigParam build() {
            this._checkSingleUse();
            return new SourceConfigParam(this);
        }
    }
}

