/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.esql.list_queries;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class Body
implements JsonpSerializable {
    private final long id;
    private final String node;
    private final long startTimeMillis;
    private final long runningTimeNanos;
    private final String query;
    public static final JsonpDeserializer<Body> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Body::setupBodyDeserializer);

    private Body(Builder builder) {
        this.id = ApiTypeHelper.requireNonNull(builder.id, (Object)this, "id", 0L);
        this.node = ApiTypeHelper.requireNonNull(builder.node, this, "node");
        this.startTimeMillis = ApiTypeHelper.requireNonNull(builder.startTimeMillis, (Object)this, "startTimeMillis", 0L);
        this.runningTimeNanos = ApiTypeHelper.requireNonNull(builder.runningTimeNanos, (Object)this, "runningTimeNanos", 0L);
        this.query = ApiTypeHelper.requireNonNull(builder.query, this, "query");
    }

    public static Body of(Function<Builder, ObjectBuilder<Body>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long id() {
        return this.id;
    }

    public final String node() {
        return this.node;
    }

    public final long startTimeMillis() {
        return this.startTimeMillis;
    }

    public final long runningTimeNanos() {
        return this.runningTimeNanos;
    }

    public final String query() {
        return this.query;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("id");
        generator.write(this.id);
        generator.writeKey("node");
        generator.write(this.node);
        generator.writeKey("start_time_millis");
        generator.write(this.startTimeMillis);
        generator.writeKey("running_time_nanos");
        generator.write(this.runningTimeNanos);
        generator.writeKey("query");
        generator.write(this.query);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupBodyDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::id, JsonpDeserializer.longDeserializer(), "id");
        op.add(Builder::node, JsonpDeserializer.stringDeserializer(), "node");
        op.add(Builder::startTimeMillis, JsonpDeserializer.longDeserializer(), "start_time_millis");
        op.add(Builder::runningTimeNanos, JsonpDeserializer.longDeserializer(), "running_time_nanos");
        op.add(Builder::query, JsonpDeserializer.stringDeserializer(), "query");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<Body> {
        private Long id;
        private String node;
        private Long startTimeMillis;
        private Long runningTimeNanos;
        private String query;

        public final Builder id(long value) {
            this.id = value;
            return this;
        }

        public final Builder node(String value) {
            this.node = value;
            return this;
        }

        public final Builder startTimeMillis(long value) {
            this.startTimeMillis = value;
            return this;
        }

        public final Builder runningTimeNanos(long value) {
            this.runningTimeNanos = value;
            return this;
        }

        public final Builder query(String value) {
            this.query = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Body build() {
            this._checkSingleUse();
            return new Body(this);
        }
    }
}

