/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.indices.IndexTemplate;
import co.elastic.clients.elasticsearch.indices.SimulateIndexTemplateResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class SimulateIndexTemplateRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final String cause;
    @Nullable
    private final Boolean create;
    @Nullable
    private final Boolean includeDefaults;
    @Nullable
    private final Time masterTimeout;
    private final String name;
    private final IndexTemplate indexTemplate;
    public static final JsonpDeserializer<SimulateIndexTemplateRequest> _DESERIALIZER = SimulateIndexTemplateRequest.createSimulateIndexTemplateRequestDeserializer();
    public static final Endpoint<SimulateIndexTemplateRequest, SimulateIndexTemplateResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<SimulateIndexTemplateRequest, SimulateIndexTemplateResponse>("es/indices.simulate_index_template", request -> "POST", request -> {
        boolean _name = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_index_template");
            buf.append("/_simulate_index");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.name, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _name = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            params.put("name", request.name);
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout._toJsonString());
        }
        if (request.create != null) {
            params.put("create", String.valueOf(request.create));
        }
        if (request.cause != null) {
            params.put("cause", request.cause);
        }
        if (request.includeDefaults != null) {
            params.put("include_defaults", String.valueOf(request.includeDefaults));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, SimulateIndexTemplateResponse._DESERIALIZER);

    private SimulateIndexTemplateRequest(Builder builder) {
        this.cause = builder.cause;
        this.create = builder.create;
        this.includeDefaults = builder.includeDefaults;
        this.masterTimeout = builder.masterTimeout;
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.indexTemplate = ApiTypeHelper.requireNonNull(builder.indexTemplate, this, "indexTemplate");
    }

    public static SimulateIndexTemplateRequest of(Function<Builder, ObjectBuilder<SimulateIndexTemplateRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String cause() {
        return this.cause;
    }

    @Nullable
    public final Boolean create() {
        return this.create;
    }

    @Nullable
    public final Boolean includeDefaults() {
        return this.includeDefaults;
    }

    @Nullable
    public final Time masterTimeout() {
        return this.masterTimeout;
    }

    public final String name() {
        return this.name;
    }

    public final IndexTemplate indexTemplate() {
        return this.indexTemplate;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        this.indexTemplate.serialize(generator, mapper);
    }

    protected static JsonpDeserializer<SimulateIndexTemplateRequest> createSimulateIndexTemplateRequestDeserializer() {
        JsonpDeserializer<IndexTemplate> valueDeserializer = IndexTemplate._DESERIALIZER;
        return JsonpDeserializer.of(valueDeserializer.acceptedEvents(), (parser, mapper, event) -> new Builder().indexTemplate((IndexTemplate)valueDeserializer.deserialize((JsonParser)parser, (JsonpMapper)mapper, (JsonParser.Event)event)).build());
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<SimulateIndexTemplateRequest> {
        @Nullable
        private String cause;
        @Nullable
        private Boolean create;
        @Nullable
        private Boolean includeDefaults;
        @Nullable
        private Time masterTimeout;
        private String name;
        private IndexTemplate indexTemplate;

        public final Builder cause(@Nullable String value) {
            this.cause = value;
            return this;
        }

        public final Builder create(@Nullable Boolean value) {
            this.create = value;
            return this;
        }

        public final Builder includeDefaults(@Nullable Boolean value) {
            this.includeDefaults = value;
            return this;
        }

        public final Builder masterTimeout(@Nullable Time value) {
            this.masterTimeout = value;
            return this;
        }

        public final Builder masterTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.masterTimeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        public final Builder indexTemplate(IndexTemplate value) {
            this.indexTemplate = value;
            return this;
        }

        public final Builder indexTemplate(Function<IndexTemplate.Builder, ObjectBuilder<IndexTemplate>> fn) {
            return this.indexTemplate(fn.apply(new IndexTemplate.Builder()).build());
        }

        @Override
        public Builder withJson(JsonParser parser, JsonpMapper mapper) {
            IndexTemplate value = IndexTemplate._DESERIALIZER.deserialize(parser, mapper);
            return this.indexTemplate(value);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SimulateIndexTemplateRequest build() {
            this._checkSingleUse();
            return new SimulateIndexTemplateRequest(this);
        }
    }
}

