/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.get_data_stream_mappings;

import co.elastic.clients.elasticsearch._types.mapping.TypeMapping;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class DataStreamMappings
implements JsonpSerializable {
    private final String name;
    private final TypeMapping mappings;
    private final TypeMapping effectiveMappings;
    public static final JsonpDeserializer<DataStreamMappings> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DataStreamMappings::setupDataStreamMappingsDeserializer);

    private DataStreamMappings(Builder builder) {
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.mappings = ApiTypeHelper.requireNonNull(builder.mappings, this, "mappings");
        this.effectiveMappings = ApiTypeHelper.requireNonNull(builder.effectiveMappings, this, "effectiveMappings");
    }

    public static DataStreamMappings of(Function<Builder, ObjectBuilder<DataStreamMappings>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String name() {
        return this.name;
    }

    public final TypeMapping mappings() {
        return this.mappings;
    }

    public final TypeMapping effectiveMappings() {
        return this.effectiveMappings;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("name");
        generator.write(this.name);
        generator.writeKey("mappings");
        this.mappings.serialize(generator, mapper);
        generator.writeKey("effective_mappings");
        this.effectiveMappings.serialize(generator, mapper);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupDataStreamMappingsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::mappings, TypeMapping._DESERIALIZER, "mappings");
        op.add(Builder::effectiveMappings, TypeMapping._DESERIALIZER, "effective_mappings");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<DataStreamMappings> {
        private String name;
        private TypeMapping mappings;
        private TypeMapping effectiveMappings;

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        public final Builder mappings(TypeMapping value) {
            this.mappings = value;
            return this;
        }

        public final Builder mappings(Function<TypeMapping.Builder, ObjectBuilder<TypeMapping>> fn) {
            return this.mappings(fn.apply(new TypeMapping.Builder()).build());
        }

        public final Builder effectiveMappings(TypeMapping value) {
            this.effectiveMappings = value;
            return this;
        }

        public final Builder effectiveMappings(Function<TypeMapping.Builder, ObjectBuilder<TypeMapping>> fn) {
            return this.effectiveMappings(fn.apply(new TypeMapping.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DataStreamMappings build() {
            this._checkSingleUse();
            return new DataStreamMappings(this);
        }
    }
}

