/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch.security.put_privileges.Actions;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class GetPrivilegesResponse
implements JsonpSerializable {
    private final Map<String, Map<String, Actions>> privileges;
    public static final JsonpDeserializer<GetPrivilegesResponse> _DESERIALIZER = GetPrivilegesResponse.createGetPrivilegesResponseDeserializer();

    private GetPrivilegesResponse(Builder builder) {
        this.privileges = ApiTypeHelper.unmodifiableRequired(builder.privileges, (Object)this, "privileges");
    }

    public static GetPrivilegesResponse of(Function<Builder, ObjectBuilder<GetPrivilegesResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Map<String, Map<String, Actions>> privileges() {
        return this.privileges;
    }

    @Nullable
    public final Map<String, Actions> get(String key) {
        return this.privileges.get(key);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        for (Map.Entry<String, Map<String, Actions>> item0 : this.privileges.entrySet()) {
            generator.writeKey(item0.getKey());
            generator.writeStartObject();
            if (item0.getValue() != null) {
                for (Map.Entry<String, Actions> item1 : item0.getValue().entrySet()) {
                    generator.writeKey(item1.getKey());
                    item1.getValue().serialize(generator, mapper);
                }
            }
            generator.writeEnd();
        }
        generator.writeEnd();
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static JsonpDeserializer<GetPrivilegesResponse> createGetPrivilegesResponseDeserializer() {
        JsonpDeserializer<Map<String, Map<String, Actions>>> valueDeserializer = JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringMapDeserializer(Actions._DESERIALIZER));
        return JsonpDeserializer.of(valueDeserializer.acceptedEvents(), (parser, mapper, event) -> new Builder().privileges((Map)valueDeserializer.deserialize((JsonParser)parser, (JsonpMapper)mapper, (JsonParser.Event)event)).build());
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<GetPrivilegesResponse> {
        private Map<String, Map<String, Actions>> privileges = new HashMap<String, Map<String, Actions>>();

        public final Builder privileges(Map<String, Map<String, Actions>> map) {
            this.privileges = Builder._mapPutAll(this.privileges, map);
            return this;
        }

        public final Builder privileges(String key, Map<String, Actions> value) {
            this.privileges = Builder._mapPut(this.privileges, key, value);
            return this;
        }

        @Override
        public Builder withJson(JsonParser parser, JsonpMapper mapper) {
            Map<String, Map<String, Actions>> value = JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringMapDeserializer(Actions._DESERIALIZER)).deserialize(parser, mapper);
            return this.privileges(value);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GetPrivilegesResponse build() {
            this._checkSingleUse();
            return new GetPrivilegesResponse(this);
        }
    }
}

