/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.TermsPartition;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.UnionDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class TermsInclude
implements TaggedUnion<Kind, Object>,
JsonpSerializable {
    private final Kind _kind;
    private final Object _value;
    public static final JsonpDeserializer<TermsInclude> _DESERIALIZER = JsonpDeserializer.lazy(TermsInclude::buildTermsIncludeDeserializer);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    private TermsInclude(Kind kind, Object value) {
        this._kind = kind;
        this._value = value;
    }

    private TermsInclude(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static TermsInclude of(Function<Builder, ObjectBuilder<TermsInclude>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isTerms() {
        return this._kind == Kind.Terms;
    }

    public List<String> terms() {
        return (List)TaggedUnionUtils.get(this, Kind.Terms);
    }

    public boolean isPartition() {
        return this._kind == Kind.Partition;
    }

    public TermsPartition partition() {
        return (TermsPartition)TaggedUnionUtils.get(this, Kind.Partition);
    }

    public boolean isRegexp() {
        return this._kind == Kind.Regexp;
    }

    public String regexp() {
        return (String)TaggedUnionUtils.get(this, Kind.Regexp);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        } else {
            switch (this._kind) {
                case Terms: {
                    generator.writeStartArray();
                    for (String item0 : (List)this._value) {
                        generator.write(item0);
                    }
                    generator.writeEnd();
                    break;
                }
                case Regexp: {
                    generator.write((String)this._value);
                }
            }
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    private static JsonpDeserializer<TermsInclude> buildTermsIncludeDeserializer() {
        return new UnionDeserializer.Builder<TermsInclude, Kind, Object>(TermsInclude::new, false).addMember(Kind.Terms, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer())).addMember(Kind.Partition, TermsPartition._DESERIALIZER).addMember(Kind.Regexp, JsonpDeserializer.stringDeserializer()).build();
    }

    public static enum Kind {
        Terms,
        Partition,
        Regexp;

    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<TermsInclude> {
        private Kind _kind;
        private Object _value;

        public ObjectBuilder<TermsInclude> terms(List<String> v) {
            this._kind = Kind.Terms;
            this._value = v;
            return this;
        }

        public ObjectBuilder<TermsInclude> partition(TermsPartition v) {
            this._kind = Kind.Partition;
            this._value = v;
            return this;
        }

        public ObjectBuilder<TermsInclude> partition(Function<TermsPartition.Builder, ObjectBuilder<TermsPartition>> fn) {
            return this.partition(fn.apply(new TermsPartition.Builder()).build());
        }

        public ObjectBuilder<TermsInclude> regexp(String v) {
            this._kind = Kind.Regexp;
            this._value = v;
            return this;
        }

        @Override
        public TermsInclude build() {
            this._checkSingleUse();
            return new TermsInclude(this);
        }
    }
}

