/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.json.jackson;

import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.jackson.Jackson3JsonpGenerator;
import co.elastic.clients.json.jackson.Jackson3JsonpMapper;
import co.elastic.clients.json.jackson.Jackson3JsonpParser;
import co.elastic.clients.json.jackson.Jackson3Utils;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonReader;
import jakarta.json.JsonReaderFactory;
import jakarta.json.JsonWriter;
import jakarta.json.JsonWriterFactory;
import jakarta.json.spi.JsonProvider;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonGeneratorFactory;
import jakarta.json.stream.JsonParser;
import jakarta.json.stream.JsonParserFactory;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Map;
import tools.jackson.core.JacksonException;
import tools.jackson.core.json.JsonFactory;

public class Jackson3JsonProvider
extends JsonProvider {
    private final Jackson3JsonpMapper mapper;
    private final JsonFactory jsonFactory;
    private final ParserFactory defaultParserFactory = new ParserFactory(null);
    private final JsonGeneratorFactory defaultGeneratorFactory = new GeneratorFactory(null);

    public Jackson3JsonProvider(Jackson3JsonpMapper mapper) {
        this.mapper = mapper;
        this.jsonFactory = mapper.objectMapper().tokenStreamFactory();
    }

    public Jackson3JsonProvider() {
        this(new Jackson3JsonpMapper());
    }

    public Jackson3JsonpMapper mapper() {
        return this.mapper;
    }

    public JsonParserFactory createParserFactory(Map<String, ?> config) {
        if (config == null || config.isEmpty()) {
            return this.defaultParserFactory;
        }
        return this.defaultParserFactory;
    }

    public JsonParser createParser(Reader reader) {
        return this.defaultParserFactory.createParser(reader);
    }

    public JsonParser createParser(InputStream in) {
        return this.defaultParserFactory.createParser(in);
    }

    public JsonGeneratorFactory createGeneratorFactory(Map<String, ?> config) {
        if (config == null || config.isEmpty()) {
            return this.defaultGeneratorFactory;
        }
        return this.defaultGeneratorFactory;
    }

    public JsonGenerator createGenerator(Writer writer) {
        return this.defaultGeneratorFactory.createGenerator(writer);
    }

    public JsonGenerator createGenerator(OutputStream out) {
        return this.defaultGeneratorFactory.createGenerator(out);
    }

    public JsonReader createReader(Reader reader) {
        throw new UnsupportedOperationException();
    }

    public JsonReader createReader(InputStream in) {
        throw new UnsupportedOperationException();
    }

    public JsonWriter createWriter(Writer writer) {
        throw new UnsupportedOperationException();
    }

    public JsonWriter createWriter(OutputStream out) {
        throw new UnsupportedOperationException();
    }

    public JsonWriterFactory createWriterFactory(Map<String, ?> config) {
        throw new UnsupportedOperationException();
    }

    public JsonReaderFactory createReaderFactory(Map<String, ?> config) {
        throw new UnsupportedOperationException();
    }

    public JsonObjectBuilder createObjectBuilder() {
        throw new UnsupportedOperationException();
    }

    public JsonArrayBuilder createArrayBuilder() {
        throw new UnsupportedOperationException();
    }

    public JsonBuilderFactory createBuilderFactory(Map<String, ?> config) {
        throw new UnsupportedOperationException();
    }

    private class ParserFactory
    implements JsonParserFactory {
        private final Map<String, ?> config;

        ParserFactory(Map<String, ?> config) {
            this.config = config == null ? Collections.emptyMap() : config;
        }

        public JsonParser createParser(Reader reader) {
            try {
                return new Jackson3JsonpParser(Jackson3JsonProvider.this.mapper.objectMapper().createParser(reader), Jackson3JsonProvider.this.mapper);
            }
            catch (JacksonException e) {
                throw Jackson3Utils.convertException(e);
            }
        }

        public JsonParser createParser(InputStream in) {
            try {
                return new Jackson3JsonpParser(Jackson3JsonProvider.this.mapper.objectMapper().createParser(in), Jackson3JsonProvider.this.mapper);
            }
            catch (JacksonException e) {
                throw Jackson3Utils.convertException(e);
            }
        }

        public JsonParser createParser(InputStream in, Charset charset) {
            try {
                return new Jackson3JsonpParser(Jackson3JsonProvider.this.mapper.objectMapper().createParser((Reader)new InputStreamReader(in, charset)), Jackson3JsonProvider.this.mapper);
            }
            catch (JacksonException e) {
                throw Jackson3Utils.convertException(e);
            }
        }

        public JsonParser createParser(JsonObject obj) {
            return JsonpUtils.systemProvider().createParserFactory(null).createParser(obj);
        }

        public JsonParser createParser(JsonArray array) {
            return JsonpUtils.systemProvider().createParserFactory(null).createParser(array);
        }

        public Map<String, ?> getConfigInUse() {
            return this.config;
        }
    }

    private class GeneratorFactory
    implements JsonGeneratorFactory {
        private final Map<String, ?> config;

        GeneratorFactory(Map<String, ?> config) {
            this.config = config == null ? Collections.emptyMap() : config;
        }

        public JsonGenerator createGenerator(Writer writer) {
            try {
                return new Jackson3JsonpGenerator(Jackson3JsonProvider.this.jsonFactory.createGenerator(writer));
            }
            catch (JacksonException e) {
                throw Jackson3Utils.convertException(e);
            }
        }

        public JsonGenerator createGenerator(OutputStream out) {
            try {
                return new Jackson3JsonpGenerator(Jackson3JsonProvider.this.jsonFactory.createGenerator(out));
            }
            catch (JacksonException e) {
                throw Jackson3Utils.convertException(e);
            }
        }

        public JsonGenerator createGenerator(OutputStream out, Charset charset) {
            try {
                return new Jackson3JsonpGenerator(Jackson3JsonProvider.this.jsonFactory.createGenerator((Writer)new OutputStreamWriter(out, charset)));
            }
            catch (JacksonException e) {
                throw Jackson3Utils.convertException(e);
            }
        }

        public Map<String, ?> getConfigInUse() {
            return this.config;
        }
    }
}

